import { defineComponent, provide, computed, createBlock, openBlock, resolveDynamicComponent, unref, normalizeClass, withCtx, renderSlot, createElementBlock, createCommentVNode, createElementVNode, toDisplayString, createTextVNode } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { i as inputGroupKey } from "./keys-CwytVEYF.mjs";
const _hoisted_1 = {
  key: 0,
  class: "input-group-text"
};
const _hoisted_2 = {
  key: 0,
  class: "input-group-text"
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BInputGroup",
  props: {
    append: { default: void 0 },
    id: { default: void 0 },
    prepend: { default: void 0 },
    size: { default: "md" },
    tag: { default: "div" }
  },
  setup(__props) {
    provide(inputGroupKey, true);
    const _props = __props;
    const props = useDefaults(_props, "BInputGroup");
    const computedClasses = computed(() => ({
      [`input-group-${props.size}`]: props.size !== "md"
    }));
    const hasAppend = computed(() => !!props.append);
    const hasPrepend = computed(() => !!props.prepend);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        id: unref(props).id,
        class: normalizeClass(["input-group", computedClasses.value]),
        role: "group"
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "prepend", {}, () => [
            hasPrepend.value ? (openBlock(), createElementBlock("span", _hoisted_1, [
              createElementVNode("span", null, toDisplayString(unref(props).prepend), 1)
            ])) : createCommentVNode("", true)
          ]),
          renderSlot(_ctx.$slots, "default"),
          renderSlot(_ctx.$slots, "append", {}, () => [
            hasAppend.value ? (openBlock(), createElementBlock("span", _hoisted_2, [
              createElementVNode("span", null, toDisplayString(unref(props).append), 1)
            ])) : createCommentVNode("", true)
          ])
        ]),
        _: 3
      }, 8, ["id", "class"]);
    };
  }
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BInputGroupText",
  props: {
    tag: { default: "div" },
    text: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BInputGroupText");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), { class: "input-group-text" }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(unref(props).text), 1)
          ])
        ]),
        _: 3
      });
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BInputGroupText.vue_vue_type_script_setup_true_lang-CnIjPlIE.mjs.map
