import { defineComponent, computed, createBlock, openBlock, resolveDynamicComponent, unref, normalizeClass, withCtx, renderSlot, useAttrs, createElementBlock, mergeProps, createVNode, withModifiers, mergeModels, useModel, useTemplateRef, createTextVNode, toDisplayString } from "vue";
import { u as useAlignment } from "./useAlignment-Cw-9AVid.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { _ as _sfc_main$5 } from "./BForm.vue_vue_type_script_setup_true_lang-B9irEupU.mjs";
import { _ as _sfc_main$6 } from "./BLink.vue_vue_type_script_setup_true_lang-Crq1j_mE.mjs";
import { p as pick } from "./object-0ALvRU0O.mjs";
import { _ as _sfc_main$7 } from "./BDropdown.vue_vue_type_script_setup_true_lang-xfjnN-Pz.mjs";
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "BNav",
  props: {
    align: { default: void 0 },
    cardHeader: { type: Boolean, default: false },
    fill: { type: Boolean, default: false },
    justified: { type: Boolean, default: false },
    pills: { type: Boolean, default: false },
    small: { type: Boolean, default: false },
    tabs: { type: Boolean, default: false },
    tag: { default: "ul" },
    underline: { type: Boolean, default: false },
    vertical: { type: Boolean, default: false }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BNav");
    const alignment = useAlignment(() => props.align);
    const computedClasses = computed(() => ({
      "nav-tabs": props.tabs,
      "nav-pills": props.pills && !props.tabs,
      "card-header-tabs": !props.vertical && props.cardHeader && props.tabs,
      "card-header-pills": !props.vertical && props.cardHeader && props.pills && !props.tabs,
      "flex-column": props.vertical,
      "nav-fill": !props.vertical && props.fill,
      "nav-justified": !props.vertical && props.justified,
      [alignment.value]: !props.vertical && props.align !== void 0,
      "small": props.small,
      "nav-underline": props.underline
    }));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        class: normalizeClass(["nav", computedClasses.value])
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
});
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BNavForm",
  props: {
    role: { default: void 0 },
    wrapperAttrs: { default: void 0 },
    formClass: { default: void 0 },
    floating: { type: Boolean, default: void 0 },
    id: { default: void 0 },
    novalidate: { type: Boolean, default: void 0 },
    validated: { type: Boolean, default: void 0 }
  },
  emits: ["submit"],
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BNavForm");
    const emit = __emit;
    const attrs = useAttrs();
    const processedAttrs = computed(() => {
      const { class: wrapperClass, ...formAttrs } = attrs;
      return { wrapperClass, formAttrs };
    });
    const submitted = (e) => {
      emit("submit", e);
    };
    const liClasses = computed(() => [
      "d-flex",
      "flex-row",
      "align-items-center",
      "flex-wrap",
      processedAttrs.value.wrapperClass
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", mergeProps({ class: liClasses.value }, _ctx.wrapperAttrs), [
        createVNode(_sfc_main$5, mergeProps(processedAttrs.value.formAttrs, {
          id: unref(props).id,
          floating: unref(props).floating,
          role: unref(props).role,
          novalidate: unref(props).novalidate,
          validated: unref(props).validated,
          class: ["d-flex", unref(props).formClass],
          onSubmit: withModifiers(submitted, ["prevent"])
        }), {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default")
          ]),
          _: 3
        }, 16, ["id", "floating", "role", "novalidate", "validated", "class"])
      ], 16);
    };
  }
});
const _hoisted_1$2 = { class: "nav-item" };
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "BNavItem",
  props: {
    linkAttrs: { default: void 0 },
    linkClass: { default: void 0 },
    active: { type: Boolean, default: void 0 },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: "router-link-exact-active active" },
    href: { default: void 0 },
    icon: { type: Boolean, default: void 0 },
    noRel: { type: Boolean },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    prefetch: { type: Boolean },
    prefetchOn: {},
    noPrefetch: { type: Boolean },
    prefetchedClass: {},
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: void 0 },
    variant: { default: void 0 }
  },
  emits: ["click"],
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BNavItem");
    const emit = __emit;
    const computedLinkProps = computed(
      () => pick(props, [
        "active",
        "activeClass",
        "exactActiveClass",
        "append",
        "disabled",
        "href",
        "icon",
        "opacity",
        "opacityHover",
        "rel",
        "replace",
        "routerComponentName",
        "target",
        "to",
        "underlineOffset",
        "underlineOffsetHover",
        "underlineOpacity",
        "underlineOpacityHover",
        "underlineVariant",
        "variant"
      ])
    );
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1$2, [
        createVNode(_sfc_main$6, mergeProps({
          class: ["nav-link", _ctx.linkClass],
          tabindex: unref(props).disabled ? -1 : void 0,
          "aria-disabled": unref(props).disabled ? true : void 0
        }, { ...computedLinkProps.value, ..._ctx.linkAttrs }, {
          onClick: _cache[0] || (_cache[0] = ($event) => emit("click", $event))
        }), {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default")
          ]),
          _: 3
        }, 16, ["class", "tabindex", "aria-disabled"]),
        renderSlot(_ctx.$slots, "after")
      ]);
    };
  }
});
const _hoisted_1$1 = { class: "nav-item dropdown" };
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BNavItemDropdown",
  props: /* @__PURE__ */ mergeModels({
    ariaLabel: { default: void 0 },
    autoClose: { type: [Boolean, String], default: true },
    boundary: { default: "clippingAncestors" },
    boundaryPadding: { default: void 0 },
    disabled: { type: Boolean, default: false },
    floatingMiddleware: { default: void 0 },
    icon: { type: Boolean, default: false },
    id: { default: void 0 },
    isNav: { type: Boolean, default: true },
    menuClass: { default: void 0 },
    noCaret: { type: Boolean, default: false },
    noFlip: { type: Boolean, default: false },
    noShift: { type: Boolean, default: false },
    noSize: { type: Boolean, default: false },
    offset: { default: 0 },
    role: { default: "menu" },
    size: { default: "md" },
    noWrapper: { type: Boolean, default: void 0 },
    split: { type: Boolean, default: false },
    splitButtonType: { default: "button" },
    splitClass: { default: void 0 },
    splitDisabled: { type: Boolean, default: void 0 },
    splitHref: { default: void 0 },
    splitTo: { default: void 0 },
    splitVariant: { default: void 0 },
    strategy: { default: "absolute" },
    text: { default: void 0 },
    toggleClass: { default: void 0 },
    toggleText: { default: "Toggle dropdown" },
    variant: { default: "link" },
    wrapperClass: { default: void 0 },
    placement: { default: void 0 },
    teleportDisabled: { type: Boolean, default: false },
    teleportTo: { default: void 0 },
    initialAnimation: { type: Boolean, default: false },
    noAnimation: { type: Boolean },
    noFade: { type: Boolean },
    lazy: { type: Boolean, default: false },
    unmountLazy: { type: Boolean },
    show: { type: Boolean },
    transProps: {},
    visible: { type: Boolean }
  }, {
    "modelValue": { type: Boolean, ...{ default: false } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["split-click", "hide", "hide-prevented", "hidden", "show", "show-prevented", "shown", "toggle", "toggle-prevented", "cancel", "ok"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BNavItemDropdown");
    const emit = __emit;
    const modelValue = useModel(__props, "modelValue");
    const dropdown = useTemplateRef("_dropdown");
    const hide = () => {
      var _a;
      (_a = dropdown.value) == null ? void 0 : _a.hide();
    };
    const show = () => {
      var _a;
      (_a = dropdown.value) == null ? void 0 : _a.show();
    };
    const toggle = () => {
      var _a;
      (_a = dropdown.value) == null ? void 0 : _a.toggle();
    };
    __expose({
      hide,
      show,
      toggle
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1$1, [
        createVNode(_sfc_main$7, mergeProps({ ref: "_dropdown" }, unref(props), {
          modelValue: modelValue.value,
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => modelValue.value = $event),
          "is-nav": "",
          onShow: _cache[1] || (_cache[1] = ($event) => emit("show", $event)),
          onShown: _cache[2] || (_cache[2] = ($event) => emit("shown", $event)),
          onHide: _cache[3] || (_cache[3] = ($event) => emit("hide", $event)),
          onHidden: _cache[4] || (_cache[4] = ($event) => emit("hidden", $event)),
          onHidePrevented: _cache[5] || (_cache[5] = ($event) => emit("hide-prevented", $event)),
          onShowPrevented: _cache[6] || (_cache[6] = ($event) => emit("show-prevented", $event)),
          onTogglePrevented: _cache[7] || (_cache[7] = ($event) => emit("toggle-prevented", $event)),
          onToggle: _cache[8] || (_cache[8] = ($event) => emit("toggle", $event)),
          onSplitClick: _cache[9] || (_cache[9] = ($event) => emit("split-click", $event))
        }), {
          "button-content": withCtx(() => [
            renderSlot(_ctx.$slots, "button-content")
          ]),
          "toggle-text": withCtx(() => [
            renderSlot(_ctx.$slots, "toggle-text")
          ]),
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default", {
              hide,
              show
            })
          ]),
          _: 3
        }, 16, ["modelValue"])
      ]);
    };
  }
});
const _hoisted_1 = { class: "navbar-text" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BNavText",
  props: {
    text: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BNavText");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1, [
        renderSlot(_ctx.$slots, "default", {}, () => [
          createTextVNode(toDisplayString(unref(props).text), 1)
        ])
      ]);
    };
  }
});
export {
  _sfc_main$4 as _,
  _sfc_main$3 as a,
  _sfc_main$2 as b,
  _sfc_main$1 as c,
  _sfc_main as d
};
//# sourceMappingURL=BNavText.vue_vue_type_script_setup_true_lang-CU1mkgY_.mjs.map
