import { defineComponent, computed, createBlock, openBlock, resolveDynamicComponent, unref, normalizeClass, withCtx, mergeProps, createSlots, renderSlot, createVNode, createCommentVNode, createElementVNode, createElementBlock, Fragment, renderList } from "vue";
import { _ as _sfc_main$5, d as _sfc_main$6 } from "./BCard.vue_vue_type_script_setup_true_lang-B87L_9wi.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { _ as _sfc_main$7 } from "./BTableSimple.vue_vue_type_script_setup_true_lang-D2TvxSs4.mjs";
import { u as useColorVariantClasses } from "./useColorVariantClasses-ZDE19TZw.mjs";
import { u as useToNumber } from "./index-CYfoub2y.mjs";
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BPlaceholder",
  props: {
    animation: { default: void 0 },
    cols: { default: 12 },
    size: { default: "md" },
    tag: { default: "span" },
    variant: { default: null },
    width: { default: void 0 },
    wrapperTag: { default: "span" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BPlaceholder");
    const widthString = computed(
      () => props.width === void 0 ? void 0 : typeof props.width === "number" ? props.width.toString() : props.width.replace("%", "")
    );
    const colsString = computed(
      () => props.cols === void 0 ? void 0 : typeof props.cols === "number" ? props.cols.toString() : props.cols
    );
    const colorClasses = useColorVariantClasses(
      computed(() => ({
        bgVariant: props.variant
      }))
    );
    const computedClasses = computed(() => [
      colorClasses.value,
      {
        [`col-${colsString.value}`]: colsString.value !== void 0 && widthString.value === void 0,
        [`placeholder-${props.size}`]: props.size !== "md"
      }
    ]);
    const wrapperClasses = computed(() => ({
      [`placeholder-${props.animation}`]: props.animation !== void 0
    }));
    const computedStyle = computed(() => ({
      width: widthString.value === void 0 ? void 0 : `${widthString.value}%`
    }));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).wrapperTag), {
        class: normalizeClass(wrapperClasses.value)
      }, {
        default: withCtx(() => [
          (openBlock(), createBlock(resolveDynamicComponent(_ctx.tag), mergeProps(_ctx.$attrs, {
            class: ["placeholder", computedClasses.value],
            style: computedStyle.value
          }), null, 16, ["class", "style"]))
        ]),
        _: 1
      }, 8, ["class"]);
    };
  }
});
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "BPlaceholderButton",
  props: {
    animation: { default: void 0 },
    cols: { default: void 0 },
    tag: { default: "div" },
    variant: { default: "primary" },
    width: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BPlaceholderButton");
    const computedClasses = computed(() => ({
      [`btn-${props.variant}`]: props.variant !== null
    }));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$4, {
        class: normalizeClass(["btn disabled", computedClasses.value]),
        animation: unref(props).animation,
        width: unref(props).width,
        cols: unref(props).cols,
        tag: unref(props).tag,
        style: { "cursor": "wait", "pointer-events": "auto" }
      }, null, 8, ["class", "animation", "width", "cols", "tag"]);
    };
  }
});
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "BPlaceholderCard",
  props: {
    animation: { default: void 0 },
    footerAnimation: { default: void 0 },
    footerSize: { default: "md" },
    footerVariant: { default: void 0 },
    footerWidth: { default: 100 },
    headerAnimation: { default: void 0 },
    headerSize: { default: "md" },
    headerVariant: { default: void 0 },
    headerWidth: { default: 100 },
    imgBlankColor: { default: "#868e96" },
    imgPlacement: { default: "top" },
    imgHeight: { default: 100 },
    imgSrc: { default: void 0 },
    noButton: { type: Boolean, default: false },
    noFooter: { type: Boolean, default: false },
    noHeader: { type: Boolean, default: false },
    noImg: { type: Boolean, default: false },
    size: { default: "md" },
    variant: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BPlaceholderCard");
    const defaultAttrs = computed(() => ({
      animation: props.animation,
      size: props.size,
      variant: props.variant
    }));
    const footerComponent = computed(() => !props.noButton ? _sfc_main$3 : _sfc_main$4);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$5, {
        "img-placement": unref(props).imgPlacement
      }, createSlots({
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createVNode(_sfc_main$4, mergeProps({ cols: "7" }, defaultAttrs.value), null, 16),
            createVNode(_sfc_main$4, mergeProps({ cols: "4" }, defaultAttrs.value), null, 16),
            createVNode(_sfc_main$4, mergeProps({ cols: "4" }, defaultAttrs.value), null, 16),
            createVNode(_sfc_main$4, mergeProps({ cols: "6" }, defaultAttrs.value), null, 16),
            createVNode(_sfc_main$4, mergeProps({ cols: "8" }, defaultAttrs.value), null, 16)
          ])
        ]),
        _: 2
      }, [
        !unref(props).noImg ? {
          name: "img",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "img", {}, () => [
              createVNode(_sfc_main$6, {
                blank: !unref(props).imgSrc ? true : false,
                "blank-color": unref(props).imgBlankColor,
                height: !unref(props).imgSrc ? unref(props).imgHeight : void 0,
                src: unref(props).imgSrc,
                "img-placement": unref(props).imgPlacement,
                style: { cursor: "wait" }
              }, null, 8, ["blank", "blank-color", "height", "src", "img-placement"])
            ])
          ]),
          key: "0"
        } : void 0,
        !unref(props).noHeader ? {
          name: "header",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "header", {}, () => [
              createVNode(_sfc_main$4, {
                width: unref(props).headerWidth,
                variant: unref(props).headerVariant,
                animation: unref(props).headerAnimation,
                size: unref(props).headerSize
              }, null, 8, ["width", "variant", "animation", "size"])
            ])
          ]),
          key: "1"
        } : void 0,
        !unref(props).noFooter ? {
          name: "footer",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "footer", {}, () => [
              (openBlock(), createBlock(resolveDynamicComponent(footerComponent.value), {
                width: unref(props).footerWidth,
                animation: unref(props).footerAnimation,
                size: unref(props).noButton ? unref(props).footerSize : void 0,
                variant: unref(props).footerVariant
              }, null, 8, ["width", "animation", "size", "variant"]))
            ])
          ]),
          key: "2"
        } : void 0
      ]), 1032, ["img-placement"]);
    };
  }
});
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BPlaceholderTable",
  props: {
    animation: { default: void 0 },
    cellWidth: { default: 100 },
    columns: { default: 5 },
    footerAnimation: { default: void 0 },
    footerCellWidth: { default: 100 },
    footerColumns: { default: void 0 },
    footerSize: { default: "md" },
    footerVariant: { default: void 0 },
    headerAnimation: { default: void 0 },
    headerCellWidth: { default: 100 },
    headerColumns: { default: void 0 },
    headerSize: { default: "md" },
    headerVariant: { default: void 0 },
    noHeader: { type: Boolean, default: false },
    rows: { default: 3 },
    showFooter: { type: Boolean, default: false },
    size: { default: "md" },
    variant: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BPlaceholderTable");
    const columnsToNumber = useToNumber(() => props.columns);
    const rowsToNumber = useToNumber(() => props.rows);
    const computedHeaderColumns = computed(() => props.headerColumns ?? NaN);
    const computedFooterColumns = computed(() => props.footerColumns ?? NaN);
    const headerColumnsNumber = useToNumber(computedHeaderColumns);
    const footerColumnsNumber = useToNumber(computedFooterColumns);
    const columnsNumber = computed(() => columnsToNumber.value || 5);
    const rowsNumber = computed(() => rowsToNumber.value || 3);
    const computedHeaderColumnsLength = computed(
      () => props.headerColumns === void 0 ? columnsNumber.value : headerColumnsNumber.value
    );
    const computedFooterColumnsLength = computed(
      () => props.footerColumns === void 0 ? columnsNumber.value : footerColumnsNumber.value
    );
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$7, null, {
        default: withCtx(() => [
          !unref(props).noHeader ? renderSlot(_ctx.$slots, "thead", { key: 0 }, () => [
            createElementVNode("thead", null, [
              createElementVNode("tr", null, [
                (openBlock(true), createElementBlock(Fragment, null, renderList(computedHeaderColumnsLength.value, (_, i) => {
                  return openBlock(), createElementBlock("th", { key: i }, [
                    createVNode(_sfc_main$4, {
                      size: unref(props).headerSize,
                      variant: unref(props).headerVariant,
                      animation: unref(props).headerAnimation,
                      width: unref(props).headerCellWidth
                    }, null, 8, ["size", "variant", "animation", "width"])
                  ]);
                }), 128))
              ])
            ])
          ]) : createCommentVNode("", true),
          renderSlot(_ctx.$slots, "default", {}, () => [
            createElementVNode("tbody", null, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(rowsNumber.value, (_, j) => {
                return openBlock(), createElementBlock("tr", { key: j }, [
                  (openBlock(true), createElementBlock(Fragment, null, renderList(columnsNumber.value, (__, k) => {
                    return openBlock(), createElementBlock("td", { key: k }, [
                      createVNode(_sfc_main$4, {
                        size: unref(props).size,
                        variant: unref(props).variant,
                        animation: unref(props).animation,
                        width: unref(props).cellWidth
                      }, null, 8, ["size", "variant", "animation", "width"])
                    ]);
                  }), 128))
                ]);
              }), 128))
            ])
          ]),
          unref(props).showFooter ? renderSlot(_ctx.$slots, "tfoot", { key: 1 }, () => [
            createElementVNode("tfoot", null, [
              createElementVNode("tr", null, [
                (openBlock(true), createElementBlock(Fragment, null, renderList(computedFooterColumnsLength.value, (_, l) => {
                  return openBlock(), createElementBlock("th", { key: l }, [
                    createVNode(_sfc_main$4, {
                      size: unref(props).footerSize,
                      variant: unref(props).footerVariant,
                      animation: unref(props).footerAnimation,
                      width: unref(props).footerCellWidth
                    }, null, 8, ["size", "variant", "animation", "width"])
                  ]);
                }), 128))
              ])
            ])
          ]) : createCommentVNode("", true)
        ]),
        _: 3
      });
    };
  }
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BPlaceholderWrapper",
  props: {
    loading: { type: Boolean, default: false }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BPlaceholderWrapper");
    return (_ctx, _cache) => {
      return unref(props).loading ? renderSlot(_ctx.$slots, "loading", { key: 0 }) : renderSlot(_ctx.$slots, "default", { key: 1 });
    };
  }
});
export {
  _sfc_main$4 as _,
  _sfc_main$3 as a,
  _sfc_main$2 as b,
  _sfc_main$1 as c,
  _sfc_main as d
};
//# sourceMappingURL=BPlaceholderWrapper.vue_vue_type_script_setup_true_lang-svTuMwV5.mjs.map
