import { defineComponent, computed, createElementBlock, openBlock, normalizeClass, renderSlot, unref, useSlots, ref, watch, createBlock, normalizeProps, guardReactiveProps, withCtx, createCommentVNode, withDirectives, createVNode, Fragment, renderList, mergeProps, createTextVNode, toDisplayString, vShow, resolveDynamicComponent, createElementVNode, mergeModels, useModel, onMounted, createSlots } from "vue";
import { g as get, p as pick, s as set, d as deepEqual } from "./object-0ALvRU0O.mjs";
import { _ as _sfc_main$8 } from "./BTableSimple.vue_vue_type_script_setup_true_lang-D2TvxSs4.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { a as titleCase, s as startCase } from "./stringUtils-B4XdnJx5.mjs";
import { u as useId } from "./useId-vZvGlR-1.mjs";
import { u as useToNumber } from "./index-CYfoub2y.mjs";
const formatItem = (item, fieldKey, formatter) => {
  const val = get(item, fieldKey);
  return formatter && typeof formatter === "function" ? formatter(val, fieldKey, item) : val;
};
const isTableItem = (value) => typeof value === "object" && value !== null;
const isTableField = (value) => typeof value === "object" && value !== null && "key" in value;
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  __name: "BTbody",
  props: {
    variant: { default: null }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BTbody");
    const computedClasses = computed(() => ({
      [`thead-${props.variant}`]: props.variant !== null
    }));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("tbody", {
        class: normalizeClass(computedClasses.value)
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
});
const _hoisted_1$3 = ["colspan", "rowspan", "data-label"];
const _hoisted_2$3 = { key: 0 };
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "BTd",
  props: {
    colspan: { default: void 0 },
    rowspan: { default: void 0 },
    stackedHeading: { default: void 0 },
    stickyColumn: { type: Boolean, default: false },
    variant: { default: null }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BTd");
    const computedClasses = computed(() => ({
      [`table-${props.variant}`]: props.variant !== null,
      "b-table-sticky-column": props.stickyColumn,
      "table-b-table-default": props.stickyColumn && props.variant === null
    }));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("td", {
        class: normalizeClass(computedClasses.value),
        colspan: unref(props).colspan,
        rowspan: unref(props).rowspan,
        "data-label": unref(props).stackedHeading
      }, [
        unref(props).stackedHeading ? (openBlock(), createElementBlock("div", _hoisted_2$3, [
          renderSlot(_ctx.$slots, "default")
        ])) : renderSlot(_ctx.$slots, "default", { key: 1 })
      ], 10, _hoisted_1$3);
    };
  }
});
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "BTfoot",
  props: {
    variant: { default: null }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BTfoot");
    const computedClasses = computed(() => ({
      [`table-${props.variant}`]: props.variant !== null
    }));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("tfoot", {
        class: normalizeClass(computedClasses.value)
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
});
const _hoisted_1$2 = ["scope", "colspan", "rowspan", "data-label"];
const _hoisted_2$2 = { key: 0 };
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "BTh",
  props: {
    colspan: { default: void 0 },
    rowspan: { default: void 0 },
    stackedHeading: { default: void 0 },
    stickyColumn: { type: Boolean, default: false },
    variant: { default: null },
    scope: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BTh");
    const computedClasses = computed(() => ({
      [`table-${props.variant}`]: props.variant !== null,
      "b-table-sticky-column": props.stickyColumn,
      "table-b-table-default": props.stickyColumn && props.variant === null
    }));
    const localScope = computed(
      () => props.scope ? props.scope : props.colspan ? "colgroup" : props.rowspan ? "rowgroup" : "col"
    );
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("th", {
        scope: localScope.value,
        class: normalizeClass(computedClasses.value),
        colspan: unref(props).colspan,
        rowspan: unref(props).rowspan,
        "data-label": unref(props).stackedHeading
      }, [
        unref(props).stackedHeading !== void 0 ? (openBlock(), createElementBlock("div", _hoisted_2$2, [
          renderSlot(_ctx.$slots, "default")
        ])) : renderSlot(_ctx.$slots, "default", { key: 1 })
      ], 10, _hoisted_1$2);
    };
  }
});
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "BThead",
  props: {
    variant: { default: null }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BThead");
    const computedClasses = computed(() => ({
      [`table-${props.variant}`]: props.variant !== null
    }));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("thead", {
        class: normalizeClass(computedClasses.value)
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
});
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "BTr",
  props: {
    variant: { default: null }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BTr");
    const computedClasses = computed(() => ({
      [`table-${props.variant}`]: props.variant !== null
    }));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("tr", {
        class: normalizeClass(computedClasses.value)
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
});
const getTableFieldHeadLabel = (field) => typeof field === "string" ? titleCase(field) : field.label !== void 0 ? field.label : typeof field.key === "string" ? titleCase(field.key) : field.key;
const btableSimpleProps = Object.freeze(
  Object.keys({
    bordered: 0,
    borderless: 0,
    borderVariant: 0,
    captionTop: 0,
    dark: 0,
    fixed: 0,
    hover: 0,
    id: 0,
    noBorderCollapse: 0,
    outlined: 0,
    responsive: 0,
    small: 0,
    stacked: 0,
    stickyHeader: 0,
    striped: 0,
    stripedColumns: 0,
    variant: 0,
    tableAttrs: 0,
    tableClass: 0
  })
);
const btableLiteProps = Object.freeze(
  Object.keys({
    align: 0,
    caption: 0,
    detailsTdClass: 0,
    fieldColumnClass: 0,
    fields: 0,
    footClone: 0,
    footRowVariant: 0,
    footVariant: 0,
    headRowVariant: 0,
    headVariant: 0,
    items: 0,
    labelStacked: 0,
    modelValue: 0,
    primaryKey: 0,
    tbodyClass: 0,
    tbodyTrAttrs: 0,
    tbodyTrClass: 0,
    tfootClass: 0,
    tfootTrClass: 0,
    theadClass: 0,
    theadTrClass: 0
  })
);
const getDataLabelAttr = (props, label) => props.stacked && props.labelStacked !== true ? { "data-label": label } : void 0;
const TABLE_TAG_NAMES = ["TD", "TH", "TR"];
const eventFilter = [
  "a",
  "a *",
  // Include content inside links
  "button",
  "button *",
  // Include content inside buttons
  "input:not(.disabled):not([disabled])",
  "select:not(.disabled):not([disabled])",
  "textarea:not(.disabled):not([disabled])",
  '[role="link"]',
  '[role="link"] *',
  '[role="button"]',
  '[role="button"] *',
  "[tabindex]:not(.disabled):not([disabled])"
].join(",");
const filterEvent = (event) => {
  if (!event || !event.target) {
    return false;
  }
  const el = event.target;
  if ("disabled" in el && el.disabled || TABLE_TAG_NAMES.indexOf(el.tagName) !== -1) {
    return false;
  }
  if (el.closest(".dropdown-menu")) return true;
  const label = el.tagName === "LABEL" ? el : el.closest("label");
  if (label) {
    const labelFor = label.getAttribute("for");
    const input = labelFor ? document.getElementById(labelFor) : label.querySelector("input, select, textarea");
    if (input && !input.disabled) {
      return true;
    }
  }
  return el.matches(eventFilter);
};
const _hoisted_1$1 = { key: 0 };
const _hoisted_2$1 = {
  key: 0,
  class: "b-table-stacked-label"
};
const _hoisted_3$1 = { class: "d-inline-flex flex-nowrap align-items-center gap-1" };
const _hoisted_4 = { key: 3 };
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BTableLite",
  props: {
    align: { default: void 0 },
    caption: { default: void 0 },
    detailsTdClass: { default: void 0 },
    fieldColumnClass: { type: [Function, String, Object, Array], default: void 0 },
    fields: { default: () => [] },
    footClone: { type: Boolean, default: false },
    footRowVariant: { default: void 0 },
    footVariant: { default: void 0 },
    headRowVariant: { default: void 0 },
    headVariant: { default: void 0 },
    items: { default: () => [] },
    labelStacked: { type: Boolean, default: false },
    modelValue: { default: void 0 },
    primaryKey: { default: void 0 },
    tbodyClass: { default: void 0 },
    tbodyTrAttrs: { type: [Function, Object], default: void 0 },
    tbodyTrClass: { type: [Function, String, Array, Object], default: void 0 },
    tfootClass: { default: void 0 },
    tfootTrClass: { default: void 0 },
    theadClass: { default: void 0 },
    theadTrClass: { default: void 0 },
    bordered: { type: Boolean, default: void 0 },
    borderless: { type: Boolean, default: void 0 },
    borderVariant: { default: void 0 },
    captionTop: { type: Boolean, default: void 0 },
    dark: { type: Boolean, default: void 0 },
    fixed: { type: Boolean, default: void 0 },
    hover: { type: Boolean, default: void 0 },
    id: { default: void 0 },
    noBorderCollapse: { type: Boolean, default: void 0 },
    outlined: { type: Boolean, default: void 0 },
    responsive: { type: [Boolean, String], default: void 0 },
    small: { type: Boolean, default: void 0 },
    stacked: { type: [Boolean, String], default: void 0 },
    stickyHeader: { type: [Boolean, String, Number], default: void 0 },
    striped: { type: Boolean, default: void 0 },
    stripedColumns: { type: Boolean, default: void 0 },
    variant: { default: void 0 },
    tableAttrs: {},
    tableClass: { default: void 0 }
  },
  emits: ["head-clicked", "row-clicked", "row-dblclicked", "row-contextmenu", "row-hovered", "row-unhovered", "row-middle-clicked"],
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BTableLite");
    const emit = __emit;
    const slots = useSlots();
    const computedId = useId(() => props.id);
    const generateDetailsItem = (item) => [
      item,
      item._showDetails
    ];
    const detailsMap = ref(/* @__PURE__ */ new WeakMap());
    watch(
      () => props.items,
      (items) => {
        items.forEach((item) => {
          if (!isTableItem(item)) return;
          detailsMap.value.set(...generateDetailsItem(item));
        });
      },
      { deep: true, immediate: true }
    );
    const computedTableClasses = computed(() => [
      props.tableClass,
      {
        [`align-${props.align}`]: props.align !== void 0
      }
    ]);
    const computedFields = computed(() => {
      if (!props.fields.length && props.items.length) {
        const [firstItem] = props.items;
        if (firstItem && (isTableItem(firstItem) || Array.isArray(firstItem))) {
          return Object.keys(firstItem).map((k) => {
            const label = startCase(k);
            return {
              key: k,
              label,
              tdAttr: getDataLabelAttr(props, label)
            };
          });
        }
        return [{ key: "", _noHeader: true }];
      }
      return props.fields.map((f) => {
        if (isTableField(f)) {
          const label2 = f.label ?? startCase(f.key);
          return {
            ...f,
            tdAttr: { ...getDataLabelAttr(props, label2), ...f.tdAttr }
          };
        }
        const label = startCase(f);
        return {
          key: f,
          label,
          tdAttr: getDataLabelAttr(props, label)
        };
      });
    });
    const computedFieldsTotal = computed(() => computedFields.value.length);
    const showComputedHeaders = computed(() => {
      if (computedFieldsTotal.value > 0 && computedFields.value.every((el) => el._noHeader === true))
        return false;
      return true;
    });
    const footerProps = computed(() => ({
      variant: props.footVariant ?? props.headVariant,
      class: props.tfootClass ?? props.theadClass
    }));
    const calculatedFooterSlot = (key) => slots[`foot(${String(key)})`] ? `foot(${String(key)})` : slots["foot()"] ? "foot()" : slots[`head(${String(key)})`] ? `head(${String(key)})` : "head()";
    const itemAttributes = (item, fieldKey, attr) => {
      const val = get(item, fieldKey);
      return attr && typeof attr === "function" ? attr(val, fieldKey, item) : attr;
    };
    const callThAttr = (item, field, type) => {
      const fieldKey = String(field.key);
      const val = get(item, fieldKey);
      return field.thAttr && typeof field.thAttr === "function" ? field.thAttr(val, fieldKey, item, type) : field.thAttr;
    };
    const headerClicked = (field, event, isFooter = false) => {
      emit("head-clicked", field.key, field, event, isFooter);
    };
    const toggleRowDetails = (tr) => {
      if (isTableItem(tr)) {
        const prevValue = detailsMap.value.get(tr);
        detailsMap.value.set(tr, !prevValue);
        tr._showDetails = !prevValue;
      }
    };
    const getFieldColumnClasses = (field) => [
      field.class,
      field.thClass,
      {
        "b-table-sticky-column": field.stickyColumn
      },
      props.fieldColumnClass ? typeof props.fieldColumnClass === "function" ? props.fieldColumnClass(field) : props.fieldColumnClass : null
    ];
    const getFieldRowClasses = (field, tr) => {
      var _a, _b;
      const val = get(tr, String(field.key));
      return [
        field.class,
        typeof field.tdClass === "function" ? field.tdClass(val, String(field.key), tr) : field.tdClass,
        (isTableItem(tr) ? (_a = tr._cellVariants) == null ? void 0 : _a[field.key] : false) ? `table-${(_b = tr._cellVariants) == null ? void 0 : _b[field.key]}` : null,
        {
          "b-table-sticky-column": field.stickyColumn
        }
      ];
    };
    const handleMiddleClick = (item, itemIndex, event) => {
      if (event.button === 1 && !filterEvent(event)) {
        emit("row-middle-clicked", item, itemIndex, event);
      }
    };
    const callTbodyTrAttrs = (item, type) => props.tbodyTrAttrs ? typeof props.tbodyTrAttrs === "function" ? props.tbodyTrAttrs(item, type) : props.tbodyTrAttrs : null;
    const getRowClasses = (item, type) => props.tbodyTrClass ? typeof props.tbodyTrClass === "function" ? props.tbodyTrClass(item, type) : props.tbodyTrClass : null;
    const generateTableRowId = (primaryKeyValue) => `${computedId.value}__row_${primaryKeyValue}`;
    const getCellComponent = (field) => {
      if (field == null ? void 0 : field.isRowHeader) {
        return _sfc_main$4;
      }
      return _sfc_main$6;
    };
    const computedSimpleProps = computed(() => ({
      ...pick(props, btableSimpleProps),
      tableClass: computedTableClasses.value,
      id: computedId.value
    }));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$8, normalizeProps(guardReactiveProps(computedSimpleProps.value)), {
        default: withCtx(() => [
          slots["table-colgroup"] ? (openBlock(), createElementBlock("colgroup", _hoisted_1$1, [
            renderSlot(_ctx.$slots, "table-colgroup", { fields: computedFields.value })
          ])) : createCommentVNode("", true),
          withDirectives(createVNode(_sfc_main$3, {
            variant: unref(props).headVariant,
            class: normalizeClass(unref(props).theadClass)
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "thead-top", {
                columns: computedFieldsTotal.value,
                fields: computedFields.value
              }),
              createVNode(_sfc_main$2, {
                variant: unref(props).headRowVariant,
                class: normalizeClass(unref(props).theadTrClass)
              }, {
                default: withCtx(() => [
                  (openBlock(true), createElementBlock(Fragment, null, renderList(computedFields.value, (field) => {
                    return openBlock(), createBlock(_sfc_main$4, mergeProps({
                      key: field.key,
                      scope: field.scope,
                      class: getFieldColumnClasses(field),
                      title: field.headerTitle,
                      variant: field.variant,
                      abbr: field.headerAbbr,
                      style: field.thStyle,
                      ref_for: true
                    }, callThAttr(null, field, "top"), {
                      onClick: ($event) => headerClicked(field, $event)
                    }), {
                      default: withCtx(() => [
                        renderSlot(
                          _ctx.$slots,
                          slots[`head(${String(field.key)})`] ? `head(${String(field.key)})` : "head()",
                          {
                            label: field.label,
                            column: field.key,
                            field,
                            isFoot: false
                          },
                          () => [
                            createTextVNode(toDisplayString(unref(getTableFieldHeadLabel)(field)), 1)
                          ]
                        )
                      ]),
                      _: 2
                    }, 1040, ["scope", "class", "title", "variant", "abbr", "style", "onClick"]);
                  }), 128))
                ]),
                _: 3
              }, 8, ["variant", "class"]),
              slots["thead-sub"] ? (openBlock(), createBlock(_sfc_main$2, { key: 0 }, {
                default: withCtx(() => [
                  (openBlock(true), createElementBlock(Fragment, null, renderList(computedFields.value, (field) => {
                    return openBlock(), createBlock(_sfc_main$6, {
                      key: field.key,
                      scope: "col",
                      variant: field.variant,
                      class: normalizeClass([field.class, field.thClass])
                    }, {
                      default: withCtx(() => [
                        renderSlot(_ctx.$slots, "thead-sub", {
                          items: unref(props).items,
                          fields: computedFields.value,
                          field
                        }, () => [
                          createTextVNode(toDisplayString(field.label), 1)
                        ])
                      ]),
                      _: 2
                    }, 1032, ["variant", "class"]);
                  }), 128))
                ]),
                _: 3
              })) : createCommentVNode("", true)
            ]),
            _: 3
          }, 8, ["variant", "class"]), [
            [vShow, showComputedHeaders.value]
          ]),
          createVNode(_sfc_main$7, {
            class: normalizeClass(unref(props).tbodyClass)
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "custom-body", {
                fields: computedFields.value,
                items: unref(props).items,
                columns: computedFieldsTotal.value
              }, () => [
                !unref(props).stacked && slots["top-row"] ? (openBlock(), createBlock(_sfc_main$2, mergeProps({
                  key: 0,
                  class: getRowClasses(null, "row-top")
                }, callTbodyTrAttrs(null, "row-top")), {
                  default: withCtx(() => [
                    renderSlot(_ctx.$slots, "top-row", {
                      columns: computedFieldsTotal.value,
                      fields: computedFields.value
                    })
                  ]),
                  _: 3
                }, 16, ["class"])) : createCommentVNode("", true),
                (openBlock(true), createElementBlock(Fragment, null, renderList(unref(props).items, (item, itemIndex) => {
                  return openBlock(), createElementBlock(Fragment, {
                    key: unref(props).primaryKey && unref(get)(item, unref(props).primaryKey) ? unref(get)(item, unref(props).primaryKey) : itemIndex
                  }, [
                    createVNode(_sfc_main$2, mergeProps({
                      id: unref(props).primaryKey && unref(get)(item, unref(props).primaryKey) ? generateTableRowId(unref(get)(item, unref(props).primaryKey)) : void 0,
                      class: getRowClasses(item, "row"),
                      variant: unref(isTableItem)(item) ? item._rowVariant : void 0,
                      ref_for: true
                    }, callTbodyTrAttrs(item, "row"), {
                      onClick: ($event) => !unref(filterEvent)($event) && emit("row-clicked", item, itemIndex, $event),
                      onDblclick: ($event) => !unref(filterEvent)($event) && emit("row-dblclicked", item, itemIndex, $event),
                      onContextmenu: ($event) => !unref(filterEvent)($event) && emit("row-contextmenu", item, itemIndex, $event),
                      onMouseenter: ($event) => !unref(filterEvent)($event) && emit("row-hovered", item, itemIndex, $event),
                      onMouseleave: ($event) => !unref(filterEvent)($event) && emit("row-unhovered", item, itemIndex, $event),
                      onMousedown: ($event) => handleMiddleClick(item, itemIndex, $event)
                    }), {
                      default: withCtx(() => [
                        (openBlock(true), createElementBlock(Fragment, null, renderList(computedFields.value, (field) => {
                          var _a;
                          return openBlock(), createBlock(resolveDynamicComponent(getCellComponent(field)), mergeProps({
                            key: field.key,
                            variant: (unref(isTableItem)(item) ? (_a = item._cellVariants) == null ? void 0 : _a[field.key] : false) ? null : field.variant,
                            class: getFieldRowClasses(field, item),
                            ref_for: true
                          }, itemAttributes(item, String(field.key), field.tdAttr)), {
                            default: withCtx(() => [
                              unref(props).stacked && unref(props).labelStacked ? (openBlock(), createElementBlock("label", _hoisted_2$1, toDisplayString(unref(getTableFieldHeadLabel)(field)), 1)) : createCommentVNode("", true),
                              renderSlot(
                                _ctx.$slots,
                                slots[`cell(${String(field.key)})`] ? `cell(${String(field.key)})` : "cell()",
                                {
                                  value: unref(formatItem)(item, String(field.key), field.formatter),
                                  unformatted: unref(get)(item, String(field.key)),
                                  index: itemIndex,
                                  item,
                                  field,
                                  items: _ctx.items,
                                  toggleDetails: () => toggleRowDetails(item),
                                  detailsShowing: unref(isTableItem)(item) ? detailsMap.value.get(item) ?? false : false
                                },
                                () => [
                                  !slots[`cell(${String(field.key)})`] && !slots["cell()"] ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                                    createTextVNode(toDisplayString(unref(formatItem)(item, String(field.key), field.formatter)), 1)
                                  ], 64)) : createCommentVNode("", true)
                                ]
                              )
                            ]),
                            _: 2
                          }, 1040, ["variant", "class"]);
                        }), 128))
                      ]),
                      _: 2
                    }, 1040, ["id", "class", "variant", "onClick", "onDblclick", "onContextmenu", "onMouseenter", "onMouseleave", "onMousedown"]),
                    unref(isTableItem)(item) && detailsMap.value.get(item) === true && slots["row-details"] ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                      createVNode(_sfc_main$2, {
                        "aria-hidden": "true",
                        role: "presentation",
                        class: "d-none"
                      }),
                      createVNode(_sfc_main$2, mergeProps({
                        class: getRowClasses(item, "row-details"),
                        variant: item._rowVariant,
                        ref_for: true
                      }, callTbodyTrAttrs(item, "row-details")), {
                        default: withCtx(() => [
                          createVNode(_sfc_main$6, {
                            colspan: computedFieldsTotal.value,
                            class: normalizeClass(_ctx.detailsTdClass)
                          }, {
                            default: withCtx(() => [
                              renderSlot(_ctx.$slots, "row-details", {
                                item,
                                toggleDetails: () => toggleRowDetails(item),
                                fields: computedFields.value,
                                index: itemIndex
                              })
                            ]),
                            _: 2
                          }, 1032, ["colspan", "class"])
                        ]),
                        _: 2
                      }, 1040, ["class", "variant"])
                    ], 64)) : createCommentVNode("", true)
                  ], 64);
                }), 128)),
                !unref(props).stacked && slots["bottom-row"] ? (openBlock(), createBlock(_sfc_main$2, mergeProps({
                  key: 1,
                  class: ["bottom-row", getRowClasses(null, "row-bottom")]
                }, callTbodyTrAttrs(null, "row-bottom")), {
                  default: withCtx(() => [
                    renderSlot(_ctx.$slots, "bottom-row", {
                      columns: computedFieldsTotal.value,
                      fields: computedFields.value
                    })
                  ]),
                  _: 3
                }, 16, ["class"])) : createCommentVNode("", true)
              ])
            ]),
            _: 3
          }, 8, ["class"]),
          unref(props).footClone ? (openBlock(), createBlock(_sfc_main$5, normalizeProps(mergeProps({ key: 1 }, footerProps.value)), {
            default: withCtx(() => [
              createVNode(_sfc_main$2, {
                variant: unref(props).footRowVariant ?? unref(props).headRowVariant,
                class: normalizeClass(unref(props).tfootTrClass ?? unref(props).theadTrClass)
              }, {
                default: withCtx(() => [
                  (openBlock(true), createElementBlock(Fragment, null, renderList(computedFields.value, (field) => {
                    return openBlock(), createBlock(_sfc_main$4, mergeProps({
                      key: field.key,
                      scope: "col",
                      class: getFieldColumnClasses(field),
                      title: field.headerTitle,
                      abbr: field.headerAbbr,
                      style: field.thStyle,
                      variant: field.variant,
                      ref_for: true
                    }, callThAttr(null, field, "bottom"), {
                      onClick: ($event) => headerClicked(field, $event, true)
                    }), {
                      default: withCtx(() => [
                        createElementVNode("div", _hoisted_3$1, [
                          createElementVNode("div", null, [
                            renderSlot(_ctx.$slots, calculatedFooterSlot(field.key), {
                              label: field.label,
                              column: field.key,
                              field,
                              isFoot: true
                            }, () => [
                              createTextVNode(toDisplayString(unref(getTableFieldHeadLabel)(field)), 1)
                            ])
                          ])
                        ])
                      ]),
                      _: 2
                    }, 1040, ["class", "title", "abbr", "style", "variant", "onClick"]);
                  }), 128))
                ]),
                _: 3
              }, 8, ["variant", "class"])
            ]),
            _: 3
          }, 16)) : slots["custom-foot"] ? (openBlock(), createBlock(_sfc_main$5, normalizeProps(mergeProps({ key: 2 }, footerProps.value)), {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "custom-foot", {
                fields: computedFields.value,
                items: unref(props).items,
                columns: computedFieldsTotal.value
              })
            ]),
            _: 3
          }, 16)) : createCommentVNode("", true),
          slots["table-caption"] || unref(props).caption ? (openBlock(), createElementBlock("caption", _hoisted_4, [
            renderSlot(_ctx.$slots, "table-caption", {}, () => [
              createTextVNode(toDisplayString(unref(props).caption), 1)
            ])
          ])) : createCommentVNode("", true)
        ]),
        _: 3
      }, 16);
    };
  }
});
const _hoisted_1 = {
  style: { opacity: 0.4 },
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  fill: "currentColor",
  class: "bi bi-arrow-up-short",
  viewBox: "0 0 16 16",
  "aria-hidden": ""
};
const _hoisted_2 = {
  role: "alert",
  "aria-live": "polite"
};
const _hoisted_3 = { class: "text-center my-2" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BTable",
  props: /* @__PURE__ */ mergeModels({
    provider: { default: void 0 },
    noProvider: { default: void 0 },
    noProviderPaging: { type: Boolean, default: false },
    noProviderSorting: { type: Boolean, default: false },
    noProviderFiltering: { type: Boolean, default: false },
    mustSort: { type: [Boolean, Array], default: false },
    selectable: { type: Boolean, default: false },
    multisort: { type: Boolean, default: false },
    stickySelect: { type: Boolean, default: false },
    selectHead: { type: [Boolean, String], default: true },
    selectMode: { default: "multi" },
    selectionVariant: { default: "primary" },
    busyLoadingText: { default: "Loading..." },
    perPage: { default: Number.POSITIVE_INFINITY },
    currentPage: { default: 1 },
    filter: { default: void 0 },
    filterFunction: { type: Function, default: void 0 },
    filterable: { default: void 0 },
    noLocalSorting: { type: Boolean, default: false },
    noSelectOnClick: { type: Boolean, default: false },
    noSortableIcon: { type: Boolean, default: false },
    emptyFilteredText: { default: "There are no records matching your request" },
    emptyText: { default: "There are no records to show" },
    showEmpty: { type: Boolean, default: false },
    align: { default: void 0 },
    caption: { default: void 0 },
    detailsTdClass: { default: void 0 },
    fieldColumnClass: { type: [Function, String, Object, Array], default: void 0 },
    fields: { default: () => [] },
    footClone: { type: Boolean, default: void 0 },
    footRowVariant: { default: void 0 },
    footVariant: { default: void 0 },
    headRowVariant: { default: void 0 },
    headVariant: { default: void 0 },
    items: { default: () => [] },
    labelStacked: { type: Boolean, default: void 0 },
    modelValue: { default: void 0 },
    primaryKey: { default: void 0 },
    tbodyClass: { default: void 0 },
    tbodyTrAttrs: {},
    tbodyTrClass: { type: [Function, String, Array, Object], default: void 0 },
    tfootClass: { default: void 0 },
    tfootTrClass: { default: void 0 },
    theadClass: { default: void 0 },
    theadTrClass: { default: void 0 },
    bordered: { type: Boolean, default: void 0 },
    borderless: { type: Boolean, default: void 0 },
    borderVariant: { default: void 0 },
    captionTop: { type: Boolean, default: void 0 },
    dark: { type: Boolean, default: void 0 },
    fixed: { type: Boolean, default: void 0 },
    hover: { type: Boolean, default: void 0 },
    id: { default: void 0 },
    noBorderCollapse: { type: Boolean, default: void 0 },
    outlined: { type: Boolean, default: void 0 },
    responsive: { type: [Boolean, String], default: void 0 },
    small: { type: Boolean, default: void 0 },
    stacked: { type: [Boolean, String], default: void 0 },
    stickyHeader: { type: [Boolean, String, Number], default: void 0 },
    striped: { type: Boolean, default: void 0 },
    stripedColumns: { type: Boolean, default: void 0 },
    variant: { default: void 0 },
    tableAttrs: {}
  }, {
    "sortBy": {
      default: void 0
    },
    "sortByModifiers": {},
    "busy": { type: Boolean, ...{
      default: false
    } },
    "busyModifiers": {},
    "selectedItems": {
      default: () => []
    },
    "selectedItemsModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["filtered", "head-clicked", "row-clicked", "row-dblclicked", "row-contextmenu", "row-hovered", "row-unhovered", "row-middle-clicked", "row-selected", "row-unselected", "sorted", "change"], ["update:sortBy", "update:busy", "update:selectedItems"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BTable");
    const emit = __emit;
    const slots = useSlots();
    const dynamicCellSlots = computed(
      () => Object.keys(slots).filter((key) => key.startsWith("cell("))
    );
    const dynamicFootSlots = computed(
      () => Object.keys(slots).filter((key) => key.startsWith("foot("))
    );
    const sortByModel = useModel(__props, "sortBy");
    const busyModel = useModel(__props, "busy");
    const selectedItemsModel = useModel(
      __props,
      "selectedItems"
    );
    const computedId = useId(() => props.id);
    const selectedItemsToSet = computed({
      get: () => new Set(selectedItemsModel.value),
      set: (val) => {
        selectedItemsModel.value = [...val];
      }
    });
    watch(selectedItemsToSet, (newValue, oldValue) => {
      Array.from(oldValue).filter((item) => !newValue.has(item)).forEach((item) => {
        emit("row-unselected", item);
      });
      Array.from(newValue).filter((item) => !oldValue.has(item)).forEach((item) => {
        emit("row-selected", item);
      });
    });
    const selectedItemsSetUtilities = {
      add: (item) => {
        const value = new Set(selectedItemsToSet.value);
        value.add(item);
        selectedItemsToSet.value = value;
      },
      clear: () => {
        selectedItemsToSet.value.forEach((item) => {
          selectedItemsSetUtilities.delete(item);
        });
      },
      delete: (item) => {
        const value = new Set(selectedItemsToSet.value);
        if (props.primaryKey) {
          const pkey = props.primaryKey;
          selectedItemsModel.value.forEach((v, i) => {
            const selectedKey = get(v, pkey);
            const itemKey = get(item, pkey);
            if (!!selectedKey && !!itemKey && selectedKey === itemKey) {
              value.delete(selectedItemsModel.value[i]);
            }
          });
        } else {
          value.delete(item);
        }
        selectedItemsToSet.value = value;
      },
      set: (items) => {
        selectedItemsToSet.value = new Set(items);
      },
      has: (item) => {
        if (!props.primaryKey) return selectedItemsToSet.value.has(item);
        const pkey = props.primaryKey;
        for (const selected of selectedItemsToSet.value) {
          const selectedKey = get(selected, pkey);
          const itemKey = get(item, pkey);
          if (!!selectedKey && !!itemKey && selectedKey === itemKey) return true;
        }
        return false;
      }
    };
    const internalItems = ref([]);
    const perPageNumber = useToNumber(() => props.perPage, { method: "parseInt" });
    const currentPageNumber = useToNumber(() => props.currentPage, { method: "parseInt" });
    const isFilterableTable = computed(() => !!props.filter);
    const usesProvider = computed(() => props.provider !== void 0);
    const isSelecting = computed(() => selectedItemsToSet.value.size > 0);
    const isSortable = computed(
      () => sortByModel.value !== void 0 || props.fields.some(
        (field) => typeof field === "object" && field !== null && field.sortable === true
      )
    );
    const computedFields = computed(
      () => props.fields.map((el) => {
        var _a;
        if (!isTableField(el)) {
          const label = startCase(el);
          return {
            key: el,
            label,
            tdAttr: getDataLabelAttr(props, label)
          };
        }
        const value = (_a = sortByModel.value) == null ? void 0 : _a.find((sb) => el.key === sb.key);
        const sortValue = isSortable.value === false ? void 0 : value === void 0 ? "none" : value.order === "desc" ? "descending" : value.order === "asc" ? "ascending" : "none";
        return {
          ...el,
          thAttr: {
            "aria-sort": sortValue,
            ...el.thAttr
          }
        };
      })
    );
    const tableClasses = computed(() => ({
      "b-table-busy": busyModel.value,
      "b-table-selectable": props.selectable,
      "user-select-none": props.selectable && isSelecting.value,
      "b-table-fixed": props.fixed,
      "b-table-no-border-collapse": props.noBorderCollapse
    }));
    const getBusyRowClasses = computed(() => [
      props.tbodyTrClass ? typeof props.tbodyTrClass === "function" ? props.tbodyTrClass(null, "table-busy") : props.tbodyTrClass : null
    ]);
    const getFieldColumnClasses = (field) => [
      {
        "b-table-sortable-column": isSortable.value && field.sortable
      }
    ];
    const getRowClasses = (item, type) => [
      {
        [`selected table-${props.selectionVariant}`]: props.selectable && !!item && selectedItemsSetUtilities.has(item)
      },
      props.tbodyTrClass ? typeof props.tbodyTrClass === "function" ? props.tbodyTrClass(item, type) : props.tbodyTrClass : null
    ];
    const getFormatter = (value) => typeof value.sortByFormatted === "function" ? value.sortByFormatted : value.formatter;
    const getStringValue = (ob, key) => {
      if (!isTableItem(ob)) return String(ob);
      const sortField = computedFields.value.find((el) => {
        if (isTableField(el)) return el.key === key;
        return false;
      });
      const val = get(ob, key);
      if (isTableField(sortField) && !!sortField.sortByFormatted) {
        const formatter = getFormatter(sortField);
        if (formatter) {
          return String(formatItem(ob, String(sortField.key), formatter));
        }
      }
      return typeof val === "object" && val !== null ? JSON.stringify(val) : (val == null ? void 0 : val.toString()) ?? "";
    };
    const computedItems = computed(() => {
      var _a;
      const sortByItems = (_a = sortByModel.value) == null ? void 0 : _a.filter((el) => !!el.order);
      const mapItem = (item) => {
        if (typeof item === "object" && item !== null && Object.keys(item).some((key) => key.includes("."))) {
          let newItem = {};
          for (const key in item) {
            if (key.includes(".")) {
              newItem = set(newItem, key, item[key]);
            } else {
              newItem[key] = item[key];
            }
          }
          return newItem;
        }
        return item;
      };
      const filterItem = (item) => {
        if (!isTableItem(item)) return true;
        return Object.entries(item).some(([key, val]) => {
          var _a2, _b, _c;
          if (val === null || val === void 0 || key[0] === "_" || !((_a2 = props.filterable) == null ? void 0 : _a2.includes(key)) && !!((_b = props.filterable) == null ? void 0 : _b.length))
            return false;
          if (props.filterFunction && typeof props.filterFunction === "function") {
            return props.filterFunction(item, props.filter);
          }
          const realVal = () => {
            const filterField = computedFields.value.find((el) => {
              if (isTableField(el)) return el.key === key;
              return false;
            });
            if (isTableField(filterField) && !!filterField.filterByFormatted) {
              const formatter = getFormatter(filterField);
              if (formatter) {
                return String(formatter(val, String(filterField.key), item));
              }
            }
            return typeof val === "object" ? JSON.stringify(Object.values(val)) : val.toString();
          };
          const itemValue = realVal();
          return itemValue.toLowerCase().includes(((_c = props.filter) == null ? void 0 : _c.toLowerCase()) ?? "");
        });
      };
      const mappedItems = (usesProvider.value ? internalItems.value : props.items).reduce(
        (acc, val) => {
          const item = mapItem(val);
          const shouldFilter = isFilterableTable.value && (!usesProvider.value || props.noProviderFiltering);
          if (!shouldFilter || filterItem(item)) acc.push(item);
          return acc;
        },
        []
      );
      if ((sortByItems == null ? void 0 : sortByItems.length) && (isSortable.value === true && !usesProvider.value && !props.noLocalSorting || isSortable.value === true && usesProvider.value && props.noProviderSorting)) {
        return mappedItems.sort((a, b) => {
          for (let i = 0; i < sortByItems.length; i++) {
            const { key, comparer, order } = sortByItems[i];
            const comparison = comparer ? comparer(a, b, key) : getStringValue(a, key).localeCompare(getStringValue(b, key), void 0, { numeric: true });
            if (comparison !== 0) {
              return order === "asc" ? comparison : -comparison;
            }
          }
          return 0;
        });
      }
      return mappedItems;
    });
    const emptySlotScope = computed(() => ({
      emptyFilteredText: props.emptyFilteredText,
      emptyText: props.emptyText,
      fields: computedFields.value,
      items: computedItems.value
    }));
    const computedDisplayItems = computed(() => {
      if (Number.isNaN(perPageNumber.value) || usesProvider.value && !props.noProviderPaging) {
        return computedItems.value;
      }
      return computedItems.value.slice(
        (currentPageNumber.value - 1) * (perPageNumber.value || Number.POSITIVE_INFINITY),
        currentPageNumber.value * (perPageNumber.value || Number.POSITIVE_INFINITY)
      );
    });
    watch(computedDisplayItems, (v) => {
      emit("change", v);
    });
    const handleRowSelection = (row, index, shiftClicked = false, ctrlClicked = false, metaClicked = false) => {
      if (!props.selectable) return;
      if (props.selectMode === "single" || props.selectMode === "multi") {
        if (shiftClicked || ctrlClicked) return;
        if (selectedItemsSetUtilities.has(row)) {
          selectedItemsSetUtilities.delete(row);
        } else {
          if (props.selectMode === "single") {
            selectedItemsSetUtilities.set([row]);
          } else {
            selectedItemsSetUtilities.add(row);
          }
        }
      } else {
        if (ctrlClicked || metaClicked) {
          if (selectedItemsSetUtilities.has(row)) {
            selectedItemsSetUtilities.delete(row);
          } else {
            selectedItemsSetUtilities.add(row);
          }
        } else if (shiftClicked) {
          const lastSelectedItem = [...selectedItemsToSet.value].pop();
          const lastSelectedIndex = computedItems.value.findIndex((i) => i === lastSelectedItem);
          const selectStartIndex = Math.min(lastSelectedIndex, index);
          const selectEndIndex = Math.max(lastSelectedIndex, index);
          const items = computedItems.value.slice(selectStartIndex, selectEndIndex + 1);
          selectedItemsSetUtilities.set(items);
        } else {
          selectedItemsSetUtilities.set([row]);
        }
      }
    };
    const onRowClick = (row, index, e) => {
      if (props.noSelectOnClick === false) {
        handleRowSelection(row, index, e.shiftKey, e.ctrlKey, e.metaKey);
      }
      emit("row-clicked", row, index, e);
    };
    const handleFieldSorting = (field) => {
      var _a, _b;
      if (!isSortable.value) return;
      const fieldKey = typeof field === "object" && field !== null ? field.key : field;
      const fieldSortable = typeof field === "object" && field !== null ? field.sortable : false;
      if (!(isSortable.value === true && fieldSortable === true)) return;
      const resolveOrder = (val) => {
        if (val === "asc") return "desc";
        if (val === void 0) return "asc";
        if (props.mustSort === true || Array.isArray(props.mustSort) && props.mustSort.includes(fieldKey))
          return "asc";
        return void 0;
      };
      const index = ((_a = sortByModel.value) == null ? void 0 : _a.findIndex((el) => el.key === fieldKey)) ?? -1;
      const originalValue = (_b = sortByModel.value) == null ? void 0 : _b[index];
      const updatedValue = (
        // If value is new, we default to ascending
        // Otherwise we make a temp copy of the value
        index === -1 || !originalValue ? { key: fieldKey, order: "asc" } : { ...originalValue }
      );
      const handleMultiSort = () => {
        const tmp = [...sortByModel.value ?? []];
        const val = updatedValue;
        if (index === -1) {
          tmp.push(val);
        } else {
          val.order = resolveOrder(val.order);
          tmp.splice(index, 1, val);
        }
        sortByModel.value = tmp;
        return val;
      };
      const handleSingleSort = () => {
        const val = {
          ...updatedValue,
          order: index === -1 ? updatedValue.order : resolveOrder(updatedValue.order)
        };
        const tmp = (sortByModel.value || []).map((e) => ({
          ...e,
          order: void 0
        }));
        if (index === -1) {
          tmp.push(val);
        } else {
          tmp[index] = val;
        }
        sortByModel.value = tmp;
        return val;
      };
      emit("sorted", props.multisort === true ? handleMultiSort() : handleSingleSort());
    };
    const onFieldHeadClick = (fieldKey, field, event, isFooter = false) => {
      emit("head-clicked", fieldKey, field, event, isFooter);
      handleFieldSorting(field);
    };
    const callItemsProvider = async () => {
      if (!usesProvider.value || props.provider === void 0 || busyModel.value) return;
      busyModel.value = true;
      const response = props.provider({
        currentPage: currentPageNumber.value,
        filter: props.filter,
        sortBy: sortByModel.value,
        perPage: perPageNumber.value
      });
      try {
        const items = response instanceof Promise ? await response : response;
        if (items === void 0) return;
        internalItems.value = items;
      } finally {
        busyModel.value = false;
      }
    };
    const providerPropsWatch = async (prop, val, oldVal) => {
      if (deepEqual(val, oldVal)) return;
      const inNoProvider = (key) => {
        var _a;
        return ((_a = props.noProvider) == null ? void 0 : _a.includes(key)) === true;
      };
      const noProvideWhenPaging = (prop === "currentPage" || prop === "perPage") && (inNoProvider("paging") || props.noProviderPaging === true);
      const noProvideWhenFiltering = prop === "filter" && (inNoProvider("filtering") || props.noProviderFiltering === true);
      const noProvideWhenSorting = (prop === "sortBy" || prop === "sortDesc") && (inNoProvider("sorting") || props.noProviderSorting === true);
      if (noProvideWhenPaging || noProvideWhenFiltering || noProvideWhenSorting) return;
      if (usesProvider.value === true) {
        await callItemsProvider();
      }
      if (!(prop === "currentPage" || prop === "perPage")) {
        emit("filtered", [...computedItems.value]);
      }
    };
    watch(
      () => props.filter,
      (filter, oldFilter) => {
        providerPropsWatch("filter", filter, oldFilter);
        if (filter === oldFilter || usesProvider.value) return;
        if (!filter) {
          emit("filtered", [...computedItems.value]);
        }
      }
    );
    watch(currentPageNumber, (val, oldVal) => {
      providerPropsWatch("currentPage", val, oldVal);
    });
    watch(perPageNumber, (val, oldVal) => {
      providerPropsWatch("perPage", val, oldVal);
    });
    watch(
      sortByModel,
      (val, oldVal) => {
        providerPropsWatch("sortBy", val, oldVal);
      },
      { deep: true }
    );
    watch(
      () => props.provider,
      (newValue) => {
        if (newValue === void 0) {
          internalItems.value = [];
          return;
        }
        callItemsProvider();
      }
    );
    onMounted(callItemsProvider);
    const exposedSelectableUtilities = {
      clearSelected: () => {
        if (!props.selectable) return;
        selectedItemsSetUtilities.clear();
      },
      selectAllRows: () => {
        if (!props.selectable || props.selectMode === "single") return;
        selectedItemsToSet.value = new Set(computedItems.value);
      },
      selectRow: (index) => {
        if (!props.selectable) return;
        const item = computedItems.value[index];
        if (!item || selectedItemsSetUtilities.has(item)) return;
        if (props.selectMode === "single") {
          selectedItemsSetUtilities.set([item]);
        } else {
          selectedItemsSetUtilities.add(item);
        }
      },
      unselectRow: (index) => {
        if (!props.selectable) return;
        const item = computedItems.value[index];
        if (!item || !selectedItemsSetUtilities.has(item)) return;
        selectedItemsSetUtilities.delete(item);
      },
      isRowSelected: (index) => {
        if (!props.selectable) return false;
        const item = computedItems.value[index];
        return selectedItemsSetUtilities.has(item);
      }
    };
    const computedLiteProps = computed(() => ({
      ...pick(props, [...btableLiteProps, ...btableSimpleProps]),
      tableAttrs: {
        ariaBusy: busyModel.value
      },
      items: computedDisplayItems.value,
      fields: computedFields.value,
      tableClass: tableClasses.value,
      tbodyTrClass: getRowClasses,
      fieldColumnClass: getFieldColumnClasses,
      id: computedId.value
    }));
    __expose({
      // The row selection methods are really for compat. Users should probably use the v-model though
      ...exposedSelectableUtilities,
      items: computedItems,
      displayItems: computedDisplayItems,
      getStringValue,
      refresh: callItemsProvider
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$1, mergeProps(computedLiteProps.value, {
        onHeadClicked: onFieldHeadClick,
        onRowClicked: onRowClick,
        onRowDblclicked: _cache[0] || (_cache[0] = (row, index, e) => {
          emit("row-dblclicked", row, index, e);
        }),
        onRowContextmenu: _cache[1] || (_cache[1] = (row, index, e) => {
          emit("row-contextmenu", row, index, e);
        }),
        onRowHovered: _cache[2] || (_cache[2] = (row, index, e) => {
          emit("row-hovered", row, index, e);
        }),
        onRowUnhovered: _cache[3] || (_cache[3] = (row, index, e) => {
          emit("row-unhovered", row, index, e);
        }),
        onRowMiddleClicked: _cache[4] || (_cache[4] = (row, index, e) => {
          emit("row-middle-clicked", row, index, e);
        })
      }), createSlots({
        "custom-body": withCtx((scope) => [
          busyModel.value && slots["table-busy"] ? (openBlock(), createBlock(_sfc_main$2, {
            key: 0,
            class: normalizeClass(["b-table-busy-slot", getBusyRowClasses.value])
          }, {
            default: withCtx(() => [
              createVNode(_sfc_main$6, {
                colspan: scope.fields.length
              }, {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "table-busy")
                ]),
                _: 2
              }, 1032, ["colspan"])
            ]),
            _: 2
          }, 1032, ["class"])) : unref(props).showEmpty === true && computedItems.value.length === 0 ? (openBlock(), createBlock(_sfc_main$2, {
            key: 1,
            class: "b-table-empty-row"
          }, {
            default: withCtx(() => [
              createVNode(_sfc_main$6, {
                colspan: computedFields.value.length
              }, {
                default: withCtx(() => [
                  createElementVNode("div", _hoisted_2, [
                    createElementVNode("div", _hoisted_3, [
                      isFilterableTable.value ? renderSlot(_ctx.$slots, "empty-filtered", normalizeProps(mergeProps({ key: 0 }, emptySlotScope.value)), () => [
                        createTextVNode(toDisplayString(unref(props).emptyFilteredText), 1)
                      ]) : renderSlot(_ctx.$slots, "empty", normalizeProps(mergeProps({ key: 1 }, emptySlotScope.value)), () => [
                        createTextVNode(toDisplayString(unref(props).emptyText), 1)
                      ])
                    ])
                  ])
                ]),
                _: 3
              }, 8, ["colspan"])
            ]),
            _: 3
          })) : createCommentVNode("", true)
        ]),
        _: 2
      }, [
        slots["table-colgroup"] ? {
          name: "table-colgroup",
          fn: withCtx((scope) => [
            renderSlot(_ctx.$slots, "table-colgroup", normalizeProps(guardReactiveProps(scope)))
          ]),
          key: "0"
        } : void 0,
        slots["thead-top"] ? {
          name: "thead-top",
          fn: withCtx((scope) => [
            renderSlot(_ctx.$slots, "thead-top", mergeProps(scope, {
              clearSelected: exposedSelectableUtilities.clearSelected,
              selectAllRows: exposedSelectableUtilities.selectAllRows,
              fields: computedFields.value
            }))
          ]),
          key: "1"
        } : void 0,
        slots["thead-sub"] ? {
          name: "thead-sub",
          fn: withCtx((scope) => [
            renderSlot(_ctx.$slots, "thead-sub", mergeProps(scope, { fields: computedFields.value }))
          ]),
          key: "2"
        } : void 0,
        slots["top-row"] ? {
          name: "top-row",
          fn: withCtx((scope) => [
            renderSlot(_ctx.$slots, "top-row", mergeProps(scope, { fields: computedFields.value }))
          ]),
          key: "3"
        } : void 0,
        slots["row-details"] ? {
          name: "row-details",
          fn: withCtx((scope) => [
            renderSlot(_ctx.$slots, "row-details", mergeProps(scope, {
              fields: computedFields.value,
              selectRow: (index = scope.index) => exposedSelectableUtilities.selectRow(index),
              unselectRow: (index = scope.index) => exposedSelectableUtilities.unselectRow(index),
              rowSelected: exposedSelectableUtilities.isRowSelected(scope.index)
            }))
          ]),
          key: "4"
        } : void 0,
        slots["bottom-row"] ? {
          name: "bottom-row",
          fn: withCtx((scope) => [
            renderSlot(_ctx.$slots, "bottom-row", mergeProps(scope, { fields: computedFields.value }))
          ]),
          key: "5"
        } : void 0,
        slots["custom-foot"] ? {
          name: "custom-foot",
          fn: withCtx((scope) => [
            renderSlot(_ctx.$slots, "custom-foot", mergeProps(scope, { fields: computedFields.value }))
          ]),
          key: "6"
        } : void 0,
        slots["table-caption"] ? {
          name: "table-caption",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "table-caption")
          ]),
          key: "7"
        } : void 0,
        renderList(dynamicCellSlots.value, (name) => {
          return {
            name,
            fn: withCtx((scope) => [
              renderSlot(_ctx.$slots, name, mergeProps(scope, {
                selectRow: (index = scope.index) => exposedSelectableUtilities.selectRow(index),
                unselectRow: (index = scope.index) => exposedSelectableUtilities.unselectRow(index),
                rowSelected: exposedSelectableUtilities.isRowSelected(scope.index)
              }))
            ])
          };
        }),
        renderList(dynamicFootSlots.value, (name) => {
          return {
            name,
            fn: withCtx((scope) => [
              renderSlot(_ctx.$slots, name, mergeProps(scope, {
                selectAllRows: exposedSelectableUtilities.selectAllRows,
                clearSelected: exposedSelectableUtilities.clearSelected
              }))
            ])
          };
        }),
        renderList(computedFields.value, (field) => {
          return {
            name: `head(${String(field.key)})`,
            fn: withCtx((scope) => {
              var _a, _b, _c, _d;
              return [
                renderSlot(
                  _ctx.$slots,
                  slots[`head(${String(field.key)})`] ? `head(${String(field.key)})` : "head()",
                  mergeProps(scope, {
                    selectAllRows: exposedSelectableUtilities.selectAllRows,
                    clearSelected: exposedSelectableUtilities.clearSelected
                  }),
                  () => [
                    createTextVNode(toDisplayString(unref(getTableFieldHeadLabel)(field)), 1)
                  ]
                ),
                isSortable.value && !!scope.field.sortable && unref(props).noSortableIcon === false ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                  ((_b = (_a = sortByModel.value) == null ? void 0 : _a.find((el) => el.key === scope.field.key)) == null ? void 0 : _b.order) === "asc" ? renderSlot(
                    _ctx.$slots,
                    slots[`sortAsc(${String(scope.field.key)})`] ? `sortAsc(${String(scope.field.key)})` : "sortAsc()",
                    normalizeProps(mergeProps({ key: 0 }, scope)),
                    () => [
                      _cache[5] || (_cache[5] = createElementVNode("svg", {
                        xmlns: "http://www.w3.org/2000/svg",
                        width: "24",
                        height: "24",
                        fill: "currentColor",
                        class: "bi bi-arrow-up-short",
                        viewBox: "0 0 16 16",
                        "aria-hidden": ""
                      }, [
                        createElementVNode("path", {
                          "fill-rule": "evenodd",
                          d: "M8 12a.5.5 0 0 0 .5-.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 .5.5z"
                        })
                      ], -1))
                    ]
                  ) : ((_d = (_c = sortByModel.value) == null ? void 0 : _c.find((el) => el.key === scope.field.key)) == null ? void 0 : _d.order) === "desc" ? renderSlot(
                    _ctx.$slots,
                    slots[`sortDesc(${String(scope.field.key)})`] ? `sortDesc(${String(scope.field.key)})` : "sortDesc()",
                    normalizeProps(mergeProps({ key: 1 }, scope)),
                    () => [
                      _cache[6] || (_cache[6] = createElementVNode("svg", {
                        xmlns: "http://www.w3.org/2000/svg",
                        width: "24",
                        height: "24",
                        fill: "currentColor",
                        class: "bi bi-arrow-down-short",
                        viewBox: "0 0 16 16",
                        "aria-hidden": ""
                      }, [
                        createElementVNode("path", {
                          "fill-rule": "evenodd",
                          d: "M8 4a.5.5 0 0 1 .5.5v5.793l2.146-2.147a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-3-3a.5.5 0 1 1 .708-.708L7.5 10.293V4.5A.5.5 0 0 1 8 4z"
                        })
                      ], -1))
                    ]
                  ) : renderSlot(
                    _ctx.$slots,
                    slots[`sortDefault(${String(scope.field.key)})`] ? `sortDefault(${String(scope.field.key)})` : "sortDefault()",
                    normalizeProps(mergeProps({ key: 2 }, scope)),
                    () => [
                      (openBlock(), createElementBlock("svg", _hoisted_1, _cache[7] || (_cache[7] = [
                        createElementVNode("path", {
                          "fill-rule": "evenodd",
                          d: "M8 12a.5.5 0 0 0 .5-.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 .5.5z"
                        }, null, -1)
                      ])))
                    ]
                  )
                ], 64)) : createCommentVNode("", true)
              ];
            })
          };
        })
      ]), 1040);
    };
  }
});
export {
  _sfc_main as _,
  _sfc_main$1 as a,
  _sfc_main$7 as b,
  _sfc_main$6 as c,
  _sfc_main$5 as d,
  _sfc_main$4 as e,
  _sfc_main$3 as f,
  _sfc_main$2 as g
};
//# sourceMappingURL=BTable.vue_vue_type_script_setup_true_lang-aBfcsaMN.mjs.map
