import { defineComponent, computed, createElementBlock, openBlock, normalizeStyle, normalizeClass, createElementVNode, normalizeProps, guardReactiveProps, renderSlot, mergeProps } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { u as useNumberishToStyle } from "./useNumberishToStyle-DZ5YuCPf.mjs";
import { u as useColorVariantClasses } from "./useColorVariantClasses-ZDE19TZw.mjs";
import { u as useId } from "./useId-vZvGlR-1.mjs";
const defaultStickyHeaderHeight = "300px";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BTableSimple",
  props: {
    bordered: { type: Boolean, default: false },
    borderless: { type: Boolean, default: false },
    borderVariant: { default: null },
    captionTop: { type: Boolean, default: false },
    dark: { type: Boolean, default: false },
    fixed: { type: Boolean, default: false },
    hover: { type: Boolean, default: false },
    id: { default: void 0 },
    noBorderCollapse: { type: Boolean, default: false },
    outlined: { type: Boolean, default: false },
    responsive: { type: [Boolean, String], default: false },
    small: { type: Boolean, default: false },
    stacked: { type: [Boolean, String], default: false },
    stickyHeader: { type: [Boolean, String, Number], default: false },
    striped: { type: Boolean, default: false },
    stripedColumns: { type: Boolean, default: false },
    variant: { default: null },
    tableAttrs: { default: void 0 },
    tableClass: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BTableSimple");
    const computedId = useId(() => props.id);
    const colorClasses = useColorVariantClasses(
      computed(() => ({
        borderVariant: props.borderVariant
      }))
    );
    const computedClasses = computed(() => [
      props.tableClass,
      "table",
      "b-table",
      colorClasses.value,
      {
        "border": props.outlined,
        "table-bordered": props.bordered,
        "table-borderless": props.borderless,
        "caption-top": props.captionTop,
        "table-dark": props.dark,
        "table-hover": props.hover,
        "b-table-stacked": props.stacked === true,
        [`b-table-stacked-${props.stacked}`]: typeof props.stacked === "string",
        "table-striped": props.striped,
        "table-sm": props.small,
        [`table-${props.variant}`]: props.variant !== null,
        "table-striped-columns": props.stripedColumns,
        "b-table-fixed": props.fixed,
        "b-table-no-border-collapse": props.noBorderCollapse
      }
    ]);
    const computedTableAttrs = computed(() => ({
      id: computedId.value,
      class: computedClasses.value,
      ...props.tableAttrs
    }));
    const computedSticky = useNumberishToStyle(
      computed(
        () => (props.stickyHeader === true ? defaultStickyHeaderHeight : props.stickyHeader) || NaN
      )
    );
    const stickyIsValid = computed(() => props.stickyHeader !== false);
    const isResponsive = computed(() => props.responsive !== false || stickyIsValid.value);
    const responsiveStyles = computed(
      () => stickyIsValid.value ? { maxHeight: computedSticky.value } : void 0
    );
    const responsiveClasses = computed(() => ({
      "table-responsive": props.responsive === true,
      [`table-responsive-${props.responsive}`]: typeof props.responsive === "string",
      "b-table-sticky-header": stickyIsValid.value
    }));
    return (_ctx, _cache) => {
      return isResponsive.value ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass(responsiveClasses.value),
        style: normalizeStyle(responsiveStyles.value)
      }, [
        createElementVNode("table", normalizeProps(guardReactiveProps(computedTableAttrs.value)), [
          renderSlot(_ctx.$slots, "default")
        ], 16)
      ], 6)) : (openBlock(), createElementBlock("table", normalizeProps(mergeProps({ key: 1 }, computedTableAttrs.value)), [
        renderSlot(_ctx.$slots, "default")
      ], 16));
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BTableSimple.vue_vue_type_script_setup_true_lang-D2TvxSs4.mjs.map
