import { defineComponent, mergeModels, useSlots, useModel, inject, ref, computed, useTemplateRef, useAttrs, onUnmounted, watch, createBlock, openBlock, resolveDynamicComponent, unref, mergeProps, withCtx, renderSlot, createCommentVNode, nextTick, onMounted, provide, toRef, normalizeClass, createVNode, createElementVNode, createElementBlock, Fragment, renderList, withModifiers, withKeys, createTextVNode, toDisplayString } from "vue";
import { B as BvEvent } from "./classes-B4vxmOuN.mjs";
import { u as useAlignment } from "./useAlignment-Cw-9AVid.mjs";
import { u as useId } from "./useId-vZvGlR-1.mjs";
import { j as createReusableTemplate } from "./index-Ddaqsxfw.mjs";
import { u as tabsInjectionKey } from "./keys-CwytVEYF.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { s as sortSlotElementsByPosition } from "./dom-BNfqkuY-.mjs";
import { f as flattenFragments } from "./flattenFragments-BoFLyuna.mjs";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BTab",
  props: /* @__PURE__ */ mergeModels({
    buttonId: { default: void 0 },
    disabled: { type: Boolean, default: false },
    id: { default: void 0 },
    lazy: { type: Boolean, default: void 0 },
    unmountLazy: { type: Boolean, default: void 0 },
    noBody: { type: Boolean, default: false },
    tag: { default: "div" },
    title: { default: void 0 },
    titleItemClass: { default: void 0 },
    titleLinkAttrs: { default: void 0 },
    titleLinkClass: { default: void 0 }
  }, {
    "active": { type: Boolean, ...{
      default: false
    } },
    "activeModifiers": {}
  }),
  emits: ["update:active"],
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BTab");
    const slots = useSlots();
    const activeModel = useModel(__props, "active");
    const parentData = inject(tabsInjectionKey, null);
    const localId = ref(props.id);
    const internalId = useId("", "tabpane");
    const computedId = computed(() => props.id ?? localId.value ?? internalId.value);
    const computedButtonId = useId(() => props.buttonId, "tab");
    const lazyRenderCompleted = ref(false);
    const el = useTemplateRef("_el");
    const attrs = useAttrs();
    const processedAttrs = computed(() => {
      const { onClick: _, ...tabAttrs } = attrs;
      return tabAttrs;
    });
    function updateTab() {
      if (!parentData) return;
      const newId = parentData.registerTab(
        computed(
          () => ({
            internalId: internalId.value,
            id: computedId.value,
            active: activeModel.value,
            buttonId: computedButtonId.value,
            disabled: props.disabled,
            title: props.title,
            titleComponent: slots.title,
            titleItemClass: props.titleItemClass,
            titleLinkAttrs: props.titleLinkAttrs,
            titleLinkClass: props.titleLinkClass,
            onClick: attrs.onClick,
            el
          })
        )
      );
      if (newId !== localId.value) {
        localId.value = newId;
      }
    }
    if (parentData) {
      updateTab();
      if (activeModel.value) {
        parentData.activateTab(internalId.value);
      }
    }
    onUnmounted(() => {
      if (!parentData) return;
      parentData.unregisterTab(internalId.value);
    });
    const isActive = computed(() => (parentData == null ? void 0 : parentData.activeId.value) === computedId.value);
    const show = ref(isActive.value);
    const computedLazy = computed(() => !!((parentData == null ? void 0 : parentData.lazy.value) || props.lazy));
    const computedActive = computed(() => isActive.value && !props.disabled);
    const showSlot = computed(
      () => computedActive.value || !computedLazy.value || computedLazy.value && !props.unmountLazy && lazyRenderCompleted.value
    );
    watch(showSlot, (shown) => {
      if (shown && !lazyRenderCompleted.value) lazyRenderCompleted.value = true;
    });
    watch(isActive, (active) => {
      if (active) {
        activeModel.value = true;
        setTimeout(() => {
          show.value = true;
        }, 0);
        return;
      }
      show.value = false;
      activeModel.value = false;
    });
    watch(activeModel, (active) => {
      if (props.disabled) {
        activeModel.value = false;
        return;
      }
      if (!parentData) return;
      if (!active) {
        if (isActive.value) {
          parentData.activateTab(void 0);
        }
        return;
      }
      if (!isActive.value) {
        parentData.activateTab(internalId.value);
      }
    });
    const computedClasses = computed(() => [
      {
        "active": isActive.value,
        "show": show.value,
        "card-body": (parentData == null ? void 0 : parentData.card.value) && props.noBody === false,
        "fade": !(parentData == null ? void 0 : parentData.noFade.value)
      },
      show.value ? parentData == null ? void 0 : parentData.activeTabClass.value : parentData == null ? void 0 : parentData.inactiveTabClass.value,
      parentData == null ? void 0 : parentData.tabClass.value
    ]);
    __expose({
      activate: () => {
        activeModel.value = true;
      },
      deactivate: () => {
        activeModel.value = false;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), mergeProps({
        id: computedId.value,
        ref: "_el",
        class: ["tab-pane", computedClasses.value],
        role: "tabpanel",
        "aria-labelledby": unref(computedButtonId)
      }, processedAttrs.value), {
        default: withCtx(() => [
          showSlot.value ? renderSlot(_ctx.$slots, "default", { key: 0 }) : createCommentVNode("", true)
        ]),
        _: 3
      }, 16, ["id", "class", "aria-labelledby"]);
    };
  }
});
const _hoisted_1 = ["aria-orientation"];
const _hoisted_2 = ["id", "aria-controls", "aria-selected", "disabled", "tabindex", "onClick"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BTabs",
  props: /* @__PURE__ */ mergeModels({
    activeNavItemClass: { default: void 0 },
    activeTabClass: { default: void 0 },
    align: { default: void 0 },
    card: { type: Boolean, default: false },
    contentClass: { default: void 0 },
    end: { type: Boolean, default: false },
    fill: { type: Boolean, default: false },
    id: { default: void 0 },
    index: {},
    inactiveNavItemClass: { default: void 0 },
    inactiveTabClass: { default: void 0 },
    justified: { type: Boolean, default: false },
    lazy: { type: Boolean, default: false },
    navClass: { default: void 0 },
    navItemClass: { default: void 0 },
    navWrapperClass: { default: void 0 },
    noFade: { type: Boolean, default: false },
    noKeyNav: { type: Boolean, default: false },
    noNavStyle: { type: Boolean, default: false },
    pills: { type: Boolean, default: false },
    small: { type: Boolean, default: false },
    tag: { default: "div" },
    tabClass: { default: void 0 },
    underline: { type: Boolean, default: false },
    vertical: { type: Boolean, default: false }
  }, {
    "index": {
      default: -1
    },
    "indexModifiers": {},
    "modelValue": {
      default: void 0
    },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["activate-tab"], ["update:index", "update:modelValue"]),
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d;
    const _props = __props;
    const props = useDefaults(_props, "BTabs");
    const emit = __emit;
    const slots = useSlots();
    const activeIndex = useModel(__props, "index");
    const activeId = useModel(__props, "modelValue");
    const ReusableEmptyTab = createReusableTemplate();
    const tabsInternal = ref([]);
    const tabElementsArray = ref([]);
    const isChildActive = ref(false);
    const initialIds = ref([]);
    const updateTabElementsArray = () => {
      var _a2;
      const tabElements = flattenFragments(((_a2 = slots.default) == null ? void 0 : _a2.call(slots, {})) ?? []);
      tabElementsArray.value = (Array.isArray(tabElements) ? tabElements : [tabElements]).filter(
        (tab) => tab.type === _sfc_main$1
      );
      if (initialIds.value.length === 0) {
        initialIds.value = tabElementsArray.value.map(
          (tab) => unref(useId(() => {
            var _a3;
            return (_a3 = tab.props) == null ? void 0 : _a3.id;
          }, "tabpane"))
        );
      }
      isChildActive.value = tabElementsArray.value.some(
        (tab) => {
          var _a3, _b2;
          return ((_a3 = tab.props) == null ? void 0 : _a3.active) !== void 0 && ((_b2 = tab.props) == null ? void 0 : _b2.active) !== false;
        }
      );
    };
    updateTabElementsArray();
    watch(
      () => {
        var _a2;
        return (_a2 = slots.default) == null ? void 0 : _a2.call(slots, {});
      },
      () => {
        updateTabElementsArray();
        nextTick(() => {
          sortTabs();
        });
      }
    );
    const tabs = computed(() => {
      if (tabsInternal.value.length === 0) {
        const _activeIndex = tabElementsArray.value.findIndex(
          (tab) => {
            var _a2, _b2;
            return ((_a2 = tab.props) == null ? void 0 : _a2.active) !== void 0 && (tab.props.disabled === false || tab.props.disabled === void 0) || activeId.value && ((_b2 = tab.props) == null ? void 0 : _b2.id) === activeId.value;
          }
        );
        return tabElementsArray.value.map((tab, index) => {
          var _a2, _b2, _c2, _d2, _e, _f, _g, _h, _i, _j, _k;
          const active = _activeIndex !== -1 ? index === _activeIndex : activeIndex.value > -1 ? index === activeIndex.value : index === 0;
          return {
            id: ((_a2 = tab.props) == null ? void 0 : _a2.id) ?? initialIds.value[index],
            internalId: `premount-${index}`,
            // temporary id for the tab
            buttonId: (_b2 = tab.props) == null ? void 0 : _b2.buttonId,
            disabled: (_c2 = tab.props) == null ? void 0 : _c2.disabled,
            title: (_d2 = tab.props) == null ? void 0 : _d2.title,
            titleComponent: (_e = tab.children) == null ? void 0 : _e.title,
            titleItemClass: (_f = tab.props) == null ? void 0 : _f.titleItemClass,
            titleLinkAttrs: (_g = tab.props) == null ? void 0 : _g.titleLinkAttrs,
            titleLinkClass: (_h = tab.props) == null ? void 0 : _h.titleLinkClass,
            onClick: (_i = tab.props) == null ? void 0 : _i.onClick,
            active,
            navItemClasses: [
              {
                active,
                disabled: !(((_j = tab.props) == null ? void 0 : _j.disabled) === false || ((_k = tab.props) == null ? void 0 : _k.disabled) === void 0)
              },
              active ? props.activeNavItemClass : props.inactiveNavItemClass,
              props.navItemClass
            ]
          };
        });
      }
      return tabsInternal.value.map((_tab) => {
        const tab = unref(_tab);
        const active = tab.id === activeId.value;
        return {
          ...tab,
          active,
          navItemClasses: [
            {
              active,
              disabled: tab.disabled
            },
            active ? props.activeNavItemClass : props.inactiveNavItemClass,
            props.navItemClass
          ]
        };
      });
    });
    let initialized = false;
    let updateInitialActiveIndex = false;
    let updateInitialActiveId = false;
    if (activeIndex.value === -1 && activeId.value) {
      if (tabs.value.findIndex((t) => t.id === activeId.value) !== -1) {
        activeIndex.value = tabs.value.findIndex((t) => t.id === activeId.value);
      } else {
        updateInitialActiveIndex = true;
      }
    } else if (activeIndex.value > -1 && !activeId.value) {
      if ((_a = tabs.value[activeIndex.value]) == null ? void 0 : _a.id) {
        activeId.value = (_b = tabs.value[activeIndex.value]) == null ? void 0 : _b.id;
      } else {
        updateInitialActiveId = true;
      }
    } else if (activeIndex.value === -1 && !activeId.value && !isChildActive.value) {
      activeIndex.value = tabs.value.findIndex((t) => t.disabled === void 0 || t.disabled === false);
      activeId.value = (_c = tabs.value[activeIndex.value]) == null ? void 0 : _c.id;
    } else if (activeIndex.value === -1 && !activeId.value && isChildActive.value) {
      activeIndex.value = tabs.value.findIndex(
        (t) => t.active !== void 0 && t.active !== false && (t.disabled === void 0 || t.disabled === false)
      );
      activeId.value = (_d = tabs.value[activeIndex.value]) == null ? void 0 : _d.id;
    }
    function updateInitialIndexAndId() {
      var _a2;
      if (updateInitialActiveIndex) {
        const index = tabs.value.findIndex((t) => t.id === activeId.value);
        if (index !== -1) {
          nextTick(() => {
            activeIndex.value = index;
            updateInitialActiveIndex = false;
          });
        }
      }
      if (updateInitialActiveId) {
        if (activeIndex.value > -1 && ((_a2 = tabs.value[activeIndex.value]) == null ? void 0 : _a2.id)) {
          nextTick(() => {
            var _a3;
            activeId.value = (_a3 = tabs.value[activeIndex.value]) == null ? void 0 : _a3.id;
            updateInitialActiveId = false;
          });
        }
      }
    }
    updateInitialIndexAndId();
    const showEmpty = computed(() => !((tabs == null ? void 0 : tabs.value) && tabs.value.length > 0));
    const computedClasses = computed(() => ({
      "d-flex": props.vertical,
      "align-items-start": props.vertical
    }));
    const alignment = useAlignment(() => props.align);
    const navTabsClasses = computed(() => ({
      "nav-pills": props.pills,
      "nav-underline": props.underline,
      "flex-column me-3": props.vertical,
      [alignment.value]: props.align !== void 0,
      "nav-fill": props.fill,
      "card-header-tabs": props.card && !props.pills && !props.underline,
      "card-header-pills": props.card && props.pills,
      "nav-justified": props.justified,
      "nav-tabs": !props.noNavStyle && !props.pills && !props.underline,
      "small": props.small
    }));
    const handleClick = (event, index) => {
      var _a2, _b2, _c2, _d2;
      if (index >= 0 && !tabs.value[index].disabled && ((_a2 = tabs.value[index]) == null ? void 0 : _a2.onClick) && typeof tabs.value[index].onClick === "function") {
        (_c2 = (_b2 = tabs.value[index]).onClick) == null ? void 0 : _c2.call(_b2, event);
        if (event.defaultPrevented) {
          (_d2 = document.getElementById(tabs.value[index].buttonId)) == null ? void 0 : _d2.blur();
          return;
        }
      }
      activeIndex.value = index;
    };
    const keynav = (e, direction) => {
      if (tabs.value.length <= 0 || props.noKeyNav) return;
      e.preventDefault();
      e.stopPropagation();
      activeIndex.value = nextIndex(activeIndex.value + direction, direction);
      nextTick(() => {
        var _a2, _b2;
        if (activeIndex.value >= 0) {
          (_b2 = document.getElementById((_a2 = tabs.value[activeIndex.value]) == null ? void 0 : _a2.buttonId)) == null ? void 0 : _b2.focus();
        }
      });
    };
    const nextIndex = (start, direction) => {
      let index = start;
      let minIdx = -1;
      let maxIdx = -1;
      for (let i = 0; i < tabs.value.length; i++) {
        if (!tabs.value[i].disabled) {
          if (minIdx === -1) minIdx = i;
          maxIdx = i;
        }
      }
      while (index >= minIdx && index <= maxIdx && tabs.value[index].disabled) {
        index += direction;
      }
      if (index < minIdx) index = minIdx;
      if (index > maxIdx) index = maxIdx;
      return index;
    };
    let previousIndex;
    let isReverting = false;
    watch(activeIndex, (newValue, oldValue) => {
      var _a2, _b2, _c2, _d2, _e, _f;
      if (tabs.value.length <= 0 || tabs.value.filter((t) => !t.disabled).length <= 0) {
        return;
      }
      if (isReverting) {
        isReverting = false;
        return;
      }
      const index = nextIndex(newValue, newValue > oldValue ? 1 : -1);
      if (index !== newValue) {
        previousIndex = oldValue;
        activeIndex.value = index;
        return;
      }
      const tabEvent = new BvEvent("activate-tab", { cancelable: true });
      emit(
        "activate-tab",
        (_a2 = tabs.value[index]) == null ? void 0 : _a2.id,
        (_b2 = tabs.value[previousIndex ?? oldValue]) == null ? void 0 : _b2.id,
        index,
        previousIndex ?? oldValue,
        tabEvent
      );
      if (tabEvent.defaultPrevented) {
        isReverting = true;
        const prev = previousIndex ?? oldValue ?? nextIndex(0, 1);
        previousIndex = void 0;
        if (activeId.value !== ((_c2 = tabs.value[prev]) == null ? void 0 : _c2.id)) {
          activeId.value = (_d2 = tabs.value[prev]) == null ? void 0 : _d2.id;
        }
        nextTick(() => {
          var _a3, _b3;
          if (prev >= 0) {
            (_b3 = document.getElementById((_a3 = tabs.value[prev]) == null ? void 0 : _a3.buttonId)) == null ? void 0 : _b3.focus();
          }
        });
        return;
      }
      if (activeId.value !== ((_e = tabs.value[index]) == null ? void 0 : _e.id)) {
        activeId.value = (_f = tabs.value[index]) == null ? void 0 : _f.id;
      }
      previousIndex = void 0;
    });
    watch(activeId, (newValue, oldValue) => {
      var _a2;
      if (tabs.value.length <= 0 || tabs.value.filter((t) => !t.disabled).length <= 0) {
        return;
      }
      const index = tabs.value.findIndex((t) => t.id === newValue);
      if (index === activeIndex.value) return;
      const oldIndex = tabs.value.findIndex((t) => t.id === oldValue);
      if ((_a2 = tabs.value[index]) == null ? void 0 : _a2.disabled) {
        activeIndex.value = nextIndex(index, index > oldIndex ? 1 : -1);
        return;
      }
      if (index === -1) {
        activeIndex.value = nextIndex(0, 1);
        nextTick(() => {
          var _a3;
          activeId.value = (_a3 = tabs.value[activeIndex.value]) == null ? void 0 : _a3.id;
        });
        return;
      }
      activeIndex.value = index;
    });
    const registerTab = (tab) => {
      const idx = tabsInternal.value.findIndex((t) => t.value.internalId === tab.value.internalId);
      if (idx === -1) {
        tabsInternal.value.push(tab);
        if (initialized) {
          nextTick(() => {
            sortTabs();
          });
        }
      } else {
        tabsInternal.value[idx] = tab;
        if (initialized) {
          sortTabs();
        }
      }
      const idx2 = tabsInternal.value.findIndex((t) => t.value.internalId === tab.value.internalId);
      return tab.value.id ?? (!initialized ? initialIds.value[idx2] : tab.value.internalId);
    };
    onMounted(() => {
      updateInitialIndexAndId();
      sortTabs();
      initialized = true;
    });
    const sortTabs = () => {
      tabsInternal.value.sort((a, b) => sortSlotElementsByPosition(a.value.el.value, b.value.el.value));
      if (activeId.value && activeIndex.value !== tabs.value.findIndex((t) => t.id === activeId.value)) {
        activeIndex.value = tabs.value.findIndex((t) => t.id === activeId.value);
      }
    };
    const unregisterTab = (id) => {
      tabsInternal.value = tabsInternal.value.filter((t) => t.value.internalId !== id);
    };
    provide(tabsInjectionKey, {
      lazy: toRef(() => props.lazy),
      card: toRef(() => props.card),
      noFade: toRef(() => props.noFade),
      activeTabClass: toRef(() => props.activeTabClass),
      inactiveTabClass: toRef(() => props.inactiveTabClass),
      tabClass: toRef(() => props.tabClass),
      registerTab,
      unregisterTab,
      activeId,
      activateTab: (internalId) => {
        const idx = tabs.value.findIndex((t) => t.internalId === internalId);
        if (internalId === void 0 || idx === -1) {
          activeIndex.value = nextIndex(0, 1);
          return;
        }
        activeIndex.value = idx;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        id: unref(props).id,
        class: normalizeClass(["tabs", computedClasses.value])
      }, {
        default: withCtx(() => [
          createVNode(unref(ReusableEmptyTab).define, null, {
            default: withCtx(() => [
              createElementVNode("div", {
                class: normalizeClass(["tab-content", unref(props).contentClass])
              }, [
                renderSlot(_ctx.$slots, "default"),
                showEmpty.value ? (openBlock(), createElementBlock("div", {
                  key: "bv-empty-tab",
                  class: normalizeClass(["tab-pane active", { "card-body": unref(props).card }])
                }, [
                  renderSlot(_ctx.$slots, "empty")
                ], 2)) : createCommentVNode("", true)
              ], 2)
            ]),
            _: 3
          }),
          unref(props).end ? (openBlock(), createBlock(unref(ReusableEmptyTab).reuse, { key: 0 })) : createCommentVNode("", true),
          createElementVNode("div", {
            class: normalizeClass([
              unref(props).navWrapperClass,
              { "card-header": unref(props).card, "ms-auto": _ctx.vertical && unref(props).end }
            ])
          }, [
            createElementVNode("ul", {
              class: normalizeClass(["nav", [navTabsClasses.value, unref(props).navClass]]),
              role: "tablist",
              "aria-orientation": unref(props).vertical ? "vertical" : "horizontal"
            }, [
              renderSlot(_ctx.$slots, "tabs-start"),
              (openBlock(true), createElementBlock(Fragment, null, renderList(tabs.value, (tab, idx) => {
                return openBlock(), createElementBlock("li", {
                  key: tab.id ?? tab.internalId,
                  class: normalizeClass(["nav-item", tab.titleItemClass]),
                  role: "presentation"
                }, [
                  createElementVNode("button", mergeProps({
                    id: tab.buttonId,
                    class: ["nav-link", [tab.navItemClasses, tab.titleLinkClass]],
                    role: "tab",
                    "aria-controls": tab.id,
                    "aria-selected": tab.active,
                    disabled: tab.disabled,
                    tabindex: unref(props).noKeyNav ? void 0 : tab.active ? void 0 : -1,
                    type: "button",
                    ref_for: true
                  }, tab.titleLinkAttrs, {
                    onKeydown: [
                      _cache[0] || (_cache[0] = withKeys(withModifiers(($event) => !unref(props).vertical && keynav($event, -1), ["exact"]), ["left"])),
                      _cache[1] || (_cache[1] = withKeys(withModifiers(($event) => !unref(props).vertical && keynav($event, -999), ["shift"]), ["left"])),
                      _cache[2] || (_cache[2] = withKeys(withModifiers(($event) => unref(props).vertical && keynav($event, -1), ["exact"]), ["up"])),
                      _cache[3] || (_cache[3] = withKeys(withModifiers(($event) => unref(props).vertical && keynav($event, -999), ["shift"]), ["up"])),
                      _cache[4] || (_cache[4] = withKeys(withModifiers(($event) => !unref(props).vertical && keynav($event, 1), ["exact"]), ["right"])),
                      _cache[5] || (_cache[5] = withKeys(withModifiers(($event) => !unref(props).vertical && keynav($event, 999), ["shift"]), ["right"])),
                      _cache[6] || (_cache[6] = withKeys(withModifiers(($event) => unref(props).vertical && keynav($event, 1), ["exact"]), ["down"])),
                      _cache[7] || (_cache[7] = withKeys(withModifiers(($event) => unref(props).vertical && keynav($event, 999), ["shift"]), ["down"])),
                      _cache[8] || (_cache[8] = withKeys(($event) => keynav($event, -999), ["page-up"])),
                      _cache[9] || (_cache[9] = withKeys(($event) => keynav($event, 999), ["page-down"])),
                      _cache[10] || (_cache[10] = withKeys(($event) => keynav($event, -999), ["home"])),
                      _cache[11] || (_cache[11] = withKeys(($event) => keynav($event, 999), ["end"]))
                    ],
                    onClick: withModifiers((e) => handleClick(e, idx), ["stop"])
                  }), [
                    tab.titleComponent ? (openBlock(), createBlock(resolveDynamicComponent(tab.titleComponent), { key: 0 })) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                      createTextVNode(toDisplayString(tab.title), 1)
                    ], 64))
                  ], 16, _hoisted_2)
                ], 2);
              }), 128)),
              renderSlot(_ctx.$slots, "tabs-end")
            ], 10, _hoisted_1)
          ], 2),
          !unref(props).end ? (openBlock(), createBlock(unref(ReusableEmptyTab).reuse, { key: 1 })) : createCommentVNode("", true)
        ]),
        _: 3
      }, 8, ["id", "class"]);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BTabs.vue_vue_type_script_setup_true_lang-CDoJ9hBp.mjs.map
