import { defineComponent, mergeModels, useSlots, useTemplateRef, useModel, computed, watchEffect, watch, createBlock, createCommentVNode, unref, openBlock, Transition, mergeProps, withCtx, withDirectives, createElementVNode, normalizeClass, createElementBlock, resolveDynamicComponent, renderSlot, normalizeProps, guardReactiveProps, toDisplayString, Fragment, withModifiers, createTextVNode, vShow, renderList, createVNode, TransitionGroup, createSlots } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { _ as _sfc_main$3 } from "./BButton.vue_vue_type_script_setup_true_lang-D-y5ASo-.mjs";
import { u as useBLinkHelper, _ as _sfc_main$2 } from "./BLink.vue_vue_type_script_setup_true_lang-Crq1j_mE.mjs";
import { _ as _sfc_main$4 } from "./BCloseButton.vue_vue_type_script_setup_true_lang-DCcXsu_x.mjs";
import { _ as _sfc_main$5 } from "./BProgress.vue_vue_type_script_setup_true_lang-BX1yVXH1.mjs";
import { u as useCountdown, a as useCountdownHover } from "./useCountdownHover-DbP9DMfh.mjs";
import { u as useColorVariantClasses } from "./useColorVariantClasses-ZDE19TZw.mjs";
import { u as useId } from "./useId-vZvGlR-1.mjs";
import { u as useShowHide } from "./useShowHide-CXGi2s6p.mjs";
import { _ as _sfc_main$6 } from "./ConditionalTeleport.vue_vue_type_script_lang-BCI6afpC.mjs";
import { useToastController } from "./src/composables/useToastController/index.mjs";
const _hoisted_1 = ["id", "role", "aria-live", "aria-atomic"];
const _hoisted_2 = {
  key: 1,
  class: "d-flex"
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BToast",
  props: /* @__PURE__ */ mergeModels({
    body: { default: void 0 },
    bodyClass: { default: void 0 },
    closeClass: { default: void 0 },
    closeContent: { default: void 0 },
    closeLabel: { default: "Close" },
    closeVariant: { default: "secondary" },
    headerClass: { default: void 0 },
    headerTag: { default: "div" },
    id: { default: void 0 },
    interval: { default: "requestAnimationFrame" },
    isStatus: { type: Boolean, default: false },
    noCloseButton: { type: Boolean, default: false },
    noHoverPause: { type: Boolean, default: false },
    noProgress: { type: Boolean, default: false },
    noResumeOnHoverLeave: { type: Boolean, default: false },
    progressProps: { default: void 0 },
    showOnPause: { type: Boolean, default: true },
    solid: { type: Boolean, default: false },
    title: { default: void 0 },
    toastClass: { default: void 0 },
    variant: { default: void 0 },
    bgVariant: { default: null },
    textVariant: { default: null },
    active: { type: Boolean, default: void 0 },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: void 0 },
    href: { default: void 0 },
    icon: { type: Boolean, default: void 0 },
    noRel: { type: Boolean, default: void 0 },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    prefetch: { type: Boolean },
    prefetchOn: {},
    noPrefetch: { type: Boolean },
    prefetchedClass: {},
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: void 0 },
    initialAnimation: { type: Boolean, default: false },
    noAnimation: { type: Boolean },
    noFade: { type: Boolean, default: false },
    lazy: { type: Boolean, default: false },
    unmountLazy: { type: Boolean, default: false },
    show: { type: Boolean, default: false },
    transProps: { default: void 0 },
    visible: { type: Boolean, default: false }
  }, {
    "modelValue": { type: [Boolean, Number], ...{ default: false } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["close", "close-countdown", "hide", "hide-prevented", "hidden", "show", "show-prevented", "shown", "toggle", "toggle-prevented", "cancel", "ok"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BToast");
    const emit = __emit;
    const slots = useSlots();
    const element = useTemplateRef("_element");
    const modelValue = useModel(__props, "modelValue");
    const { computedLink, computedLinkProps } = useBLinkHelper(props);
    const computedId = useId(() => props.id, "toast");
    const {
      showRef,
      renderRef,
      hide,
      toggle,
      show,
      buildTriggerableEvent,
      computedNoAnimation,
      isVisible,
      transitionProps,
      contentShowing
    } = useShowHide(modelValue, props, emit, element, computedId);
    const countdownLength = computed(
      () => typeof modelValue.value === "boolean" ? 0 : modelValue.value
    );
    const {
      isActive,
      pause,
      restart,
      resume,
      stop,
      isPaused,
      value: remainingMs
    } = useCountdown(countdownLength, props.interval, {
      immediate: typeof modelValue.value === "number" && !!modelValue.value
    });
    useCountdownHover(
      element,
      {
        noHoverPause: () => props.noHoverPause || typeof modelValue.value !== "number",
        noResumeOnHoverLeave: () => props.noResumeOnHoverLeave || typeof modelValue.value !== "number",
        modelValueIgnoresHover: () => typeof modelValue.value === "boolean"
      },
      { pause, resume }
    );
    watchEffect(() => {
      emit("close-countdown", remainingMs.value);
    });
    const computedTag = computed(() => computedLink.value ? _sfc_main$2 : "div");
    const isToastVisible = computed(
      () => showRef.value || isActive.value || props.showOnPause && isPaused.value
    );
    const colorClasses = useColorVariantClasses(props);
    const computedClasses = computed(() => [
      colorClasses.value,
      {
        show: isVisible.value,
        fade: !computedNoAnimation.value
      }
    ]);
    watch(modelValue, (newValue, oldValue) => {
      if (typeof newValue === "number" && newValue > 0) {
        const event = buildTriggerableEvent("show", { cancelable: true, trigger: "model" });
        emit("show", event);
        if (event.defaultPrevented) {
          emit("show-prevented", buildTriggerableEvent("show-prevented"));
        } else {
          restart();
        }
      }
      if (typeof newValue === "number" && newValue === 0) {
        stop();
      }
      if (newValue === false && typeof oldValue === "number" && oldValue > 0) {
        stop();
      }
    });
    watch(isActive, (newValue) => {
      if (newValue === false && isPaused.value === false) {
        hide();
        modelValue.value = 0;
        stop();
      }
    });
    const sharedSlots = computed(() => ({
      toggle,
      show,
      hide,
      id: computedId.value,
      visible: showRef.value,
      active: isActive.value
    }));
    __expose({
      show,
      hide,
      toggle,
      pause,
      restart,
      resume,
      stop
    });
    return (_ctx, _cache) => {
      const _component_BButton = _sfc_main$3;
      return unref(renderRef) || unref(contentShowing) ? (openBlock(), createBlock(Transition, mergeProps({ key: 0 }, unref(transitionProps), {
        appear: !!modelValue.value || unref(props).visible
      }), {
        default: withCtx(() => {
          var _a, _b, _c, _d, _e, _f;
          return [
            withDirectives(createElementVNode("div", {
              id: unref(props).id,
              ref: "_element",
              class: normalizeClass(["toast", [unref(props).toastClass, computedClasses.value]]),
              tabindex: "0",
              style: { "display": "block" },
              role: !isToastVisible.value ? void 0 : unref(props).isStatus ? "status" : "alert",
              "aria-live": !isToastVisible.value ? void 0 : unref(props).isStatus ? "polite" : "assertive",
              "aria-atomic": !isToastVisible.value ? void 0 : true
            }, [
              unref(contentShowing) && (slots.title || unref(props).title) ? (openBlock(), createBlock(resolveDynamicComponent(unref(props).headerTag), {
                key: 0,
                class: normalizeClass(["toast-header", unref(props).headerClass])
              }, {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "title", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                    createElementVNode("strong", null, toDisplayString(unref(props).title), 1)
                  ]),
                  !unref(props).noCloseButton ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                    slots.close || unref(props).closeContent ? (openBlock(), createBlock(_component_BButton, {
                      key: 0,
                      class: normalizeClass([[unref(props).closeClass], "ms-auto"]),
                      variant: unref(props).closeVariant,
                      onClick: _cache[0] || (_cache[0] = withModifiers(($event) => unref(hide)("close"), ["stop", "prevent"]))
                    }, {
                      default: withCtx(() => [
                        renderSlot(_ctx.$slots, "close", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                          createTextVNode(toDisplayString(unref(props).closeContent), 1)
                        ])
                      ]),
                      _: 3
                    }, 8, ["class", "variant"])) : (openBlock(), createBlock(_sfc_main$4, {
                      key: 1,
                      "aria-label": unref(props).closeLabel,
                      class: normalizeClass(["ms-auto", [unref(props).closeClass]]),
                      onClick: _cache[1] || (_cache[1] = withModifiers(($event) => unref(hide)("close"), ["stop", "prevent"]))
                    }, null, 8, ["aria-label", "class"]))
                  ], 64)) : createCommentVNode("", true)
                ]),
                _: 3
              }, 8, ["class"])) : createCommentVNode("", true),
              unref(contentShowing) && (slots.default || unref(props).body) ? (openBlock(), createElementBlock("div", _hoisted_2, [
                (openBlock(), createBlock(resolveDynamicComponent(computedTag.value), mergeProps({
                  class: ["toast-body", unref(props).bodyClass]
                }, unref(computedLinkProps), {
                  onClick: _cache[2] || (_cache[2] = ($event) => unref(computedLink) ? unref(hide)() : () => {
                  })
                }), {
                  default: withCtx(() => [
                    renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                      createTextVNode(toDisplayString(unref(props).body), 1)
                    ])
                  ]),
                  _: 3
                }, 16, ["class"])),
                !unref(props).noCloseButton && !(slots.title || unref(props).title) ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                  slots.close || unref(props).closeContent ? (openBlock(), createBlock(_component_BButton, {
                    key: 0,
                    class: normalizeClass([[unref(props).closeClass], "ms-auto btn-close-custom"]),
                    variant: unref(props).closeVariant,
                    onClick: _cache[3] || (_cache[3] = withModifiers(($event) => unref(hide)("close"), ["stop", "prevent"]))
                  }, {
                    default: withCtx(() => [
                      renderSlot(_ctx.$slots, "close", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                        createTextVNode(toDisplayString(unref(props).closeContent), 1)
                      ])
                    ]),
                    _: 3
                  }, 8, ["class", "variant"])) : (openBlock(), createBlock(_sfc_main$4, {
                    key: 1,
                    "aria-label": unref(props).closeLabel,
                    class: normalizeClass(["ms-auto btn-close-custom", [unref(props).closeClass]]),
                    onClick: _cache[4] || (_cache[4] = withModifiers(($event) => unref(hide)("close"), ["stop", "prevent"]))
                  }, null, 8, ["aria-label", "class"]))
                ], 64)) : createCommentVNode("", true)
              ])) : createCommentVNode("", true),
              typeof modelValue.value === "number" && !unref(props).noProgress ? (openBlock(), createBlock(_sfc_main$5, {
                key: 2,
                animated: (_a = unref(props).progressProps) == null ? void 0 : _a.animated,
                precision: (_b = unref(props).progressProps) == null ? void 0 : _b.precision,
                "show-progress": (_c = unref(props).progressProps) == null ? void 0 : _c.showProgress,
                "show-value": (_d = unref(props).progressProps) == null ? void 0 : _d.showValue,
                striped: (_e = unref(props).progressProps) == null ? void 0 : _e.striped,
                variant: (_f = unref(props).progressProps) == null ? void 0 : _f.variant,
                max: modelValue.value,
                value: unref(remainingMs),
                height: "4px"
              }, null, 8, ["animated", "precision", "show-progress", "show-value", "striped", "variant", "max", "value"])) : createCommentVNode("", true)
            ], 10, _hoisted_1), [
              [vShow, isToastVisible.value]
            ])
          ];
        }),
        _: 3
      }, 16, ["appear"])) : createCommentVNode("", true);
    };
  }
});
const positionClasses = {
  "top-start": "top-0 start-0",
  "top-center": "top-0 start-50 translate-middle-x",
  "top-end": "top-0 end-0",
  "middle-start": "top-50 start-0 translate-middle-y",
  "middle-center": "top-50 start-50 translate-middle",
  "middle-end": "top-50 end-0 translate-middle-y",
  "bottom-start": "bottom-0 start-0",
  "bottom-center": "bottom-0 start-50 translate-middle-x",
  "bottom-end": "bottom-0 end-0"
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BToastOrchestrator",
  props: {
    appendToast: { type: Boolean, default: false },
    teleportDisabled: { type: Boolean, default: false },
    teleportTo: { default: "body" }
  },
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BToastOrchestrator");
    const tools = useToastController();
    tools._isOrchestratorInstalled.value = true;
    watch(
      () => props.appendToast,
      (value) => {
        tools._isAppend.value = value;
      },
      { immediate: true }
    );
    __expose({
      ...tools
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$6, {
        to: unref(props).teleportTo,
        disabled: unref(props).teleportDisabled
      }, {
        default: withCtx(() => [
          createElementVNode("div", mergeProps({ id: "__BVID__toaster-container" }, _ctx.$attrs), [
            (openBlock(true), createElementBlock(Fragment, null, renderList(unref(positionClasses), (value, key) => {
              return openBlock(), createElementBlock("div", {
                key,
                class: normalizeClass([value, "toast-container position-fixed p-3"]),
                style: { "width": "calc(var(--bs-toast-max-width, 350px) + 2 * 1rem)" }
              }, [
                createVNode(TransitionGroup, { name: "b-list" }, {
                  default: withCtx(() => {
                    var _a;
                    return [
                      (openBlock(true), createElementBlock(Fragment, null, renderList(((_a = unref(tools).toasts) == null ? void 0 : _a.value.filter((el) => el.position === key)) || [], ({
                        _self,
                        slots,
                        promise,
                        options,
                        component: _component,
                        ...val
                      }) => {
                        return openBlock(), createElementBlock("span", { key: _self }, [
                          (openBlock(), createBlock(resolveDynamicComponent(_component ?? _sfc_main$1), mergeProps({ ref_for: true }, val, {
                            ref_for: true,
                            ref: (ref) => promise.value.ref = ref,
                            "initial-animation": "",
                            "teleport-disabled": true,
                            onHide: (e) => {
                              var _a2, _b;
                              e.ok = e.trigger === "ok" ? true : e.trigger === "cancel" ? false : null;
                              (_a2 = val.onHide) == null ? void 0 : _a2.call(val, e);
                              if (e.defaultPrevented) {
                                return;
                              }
                              (_b = promise.stop) == null ? void 0 : _b.call(promise);
                              if (options == null ? void 0 : options.resolveOnHide) {
                                promise.resolve(e);
                              }
                            },
                            onHidden: (e) => {
                              var _a2, _b, _c;
                              e.ok = e.trigger === "ok" ? true : e.trigger === "cancel" ? false : null;
                              (_a2 = val.onHidden) == null ? void 0 : _a2.call(val, e);
                              if (e.defaultPrevented) {
                                return;
                              }
                              if (!(options == null ? void 0 : options.resolveOnHide)) {
                                promise.resolve(e);
                              }
                              if (!(options == null ? void 0 : options.keep)) {
                                (_c = (_b = promise.value).destroy) == null ? void 0 : _c.call(_b);
                              }
                            }
                          }), createSlots({ _: 2 }, [
                            renderList(slots, (comp, slot) => {
                              return {
                                name: slot,
                                fn: withCtx((scope) => [
                                  (openBlock(), createBlock(resolveDynamicComponent(comp), mergeProps({ ref_for: true }, scope), null, 16))
                                ])
                              };
                            })
                          ]), 1040, ["onHide", "onHidden"]))
                        ]);
                      }), 128))
                    ];
                  }),
                  _: 2
                }, 1024)
              ], 2);
            }), 128))
          ], 16)
        ]),
        _: 1
      }, 8, ["to", "disabled"]);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BToastOrchestrator.vue_vue_type_script_setup_true_lang-FaJOn6Y0.mjs.map
