import { defineComponent, mergeModels, useSlots, useModel, computed, useTemplateRef, createBlock, openBlock, mergeProps, createSlots, withCtx, renderSlot, normalizeProps, guardReactiveProps } from "vue";
import { _ as _sfc_main$1 } from "./floatingUi-BQpU1TSt.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BTooltip",
  props: /* @__PURE__ */ mergeModels({
    interactive: { type: Boolean, default: void 0 },
    body: {},
    bodyClass: { default: void 0 },
    boundary: {},
    boundaryPadding: {},
    click: { type: Boolean, default: void 0 },
    closeOnHide: { type: Boolean },
    delay: { default: 0 },
    floatingMiddleware: { default: void 0 },
    hideMargin: { default: 0 },
    id: { default: void 0 },
    inline: { type: Boolean, default: void 0 },
    manual: { type: Boolean, default: void 0 },
    noAutoClose: { type: Boolean, default: void 0 },
    noFlip: { type: Boolean, default: void 0 },
    noHide: { type: Boolean, default: void 0 },
    noShift: { type: Boolean, default: void 0 },
    noSize: { type: Boolean },
    noninteractive: { type: Boolean, default: void 0 },
    offset: { default: void 0 },
    placement: { default: void 0 },
    realtime: { type: Boolean, default: void 0 },
    reference: { default: void 0 },
    strategy: { default: void 0 },
    target: { default: void 0 },
    title: { default: void 0 },
    titleClass: { default: void 0 },
    teleportDisabled: { type: Boolean, default: void 0 },
    teleportTo: { default: void 0 },
    initialAnimation: { type: Boolean, default: false },
    noAnimation: { type: Boolean },
    noFade: { type: Boolean, default: void 0 },
    lazy: { type: Boolean, default: void 0 },
    unmountLazy: { type: Boolean, default: void 0 },
    show: { type: Boolean, default: void 0 },
    transProps: {},
    visible: { type: Boolean, default: void 0 }
  }, {
    "modelValue": { type: Boolean, ...{
      default: false
    } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["pointerleave", "blur", "click-outside", "close-on-hide", "hide", "hide-prevented", "hidden", "show", "show-prevented", "shown", "toggle", "toggle-prevented", "cancel", "ok"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BTooltip");
    const slots = useSlots();
    const modelValue = useModel(__props, "modelValue");
    const emit = __emit;
    const computedProps = computed(() => {
      const { interactive, noninteractive, ...rest } = props;
      return { noninteractive: noninteractive !== void 0 ? noninteractive : !interactive, ...rest };
    });
    const popover = useTemplateRef("_popover");
    __expose({
      hide: () => {
        var _a;
        (_a = popover.value) == null ? void 0 : _a.hide();
      },
      show: () => {
        var _a;
        (_a = popover.value) == null ? void 0 : _a.show();
      },
      toggle: () => {
        var _a;
        (_a = popover.value) == null ? void 0 : _a.toggle();
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$1, mergeProps({ ref: "_popover" }, computedProps.value, {
        modelValue: modelValue.value,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => modelValue.value = $event),
        tooltip: "",
        onShow: _cache[1] || (_cache[1] = ($event) => emit("show", $event)),
        onShown: _cache[2] || (_cache[2] = ($event) => emit("shown", $event)),
        onHide: _cache[3] || (_cache[3] = ($event) => emit("hide", $event)),
        onHidden: _cache[4] || (_cache[4] = ($event) => emit("hidden", $event)),
        onHidePrevented: _cache[5] || (_cache[5] = ($event) => emit("hide-prevented", $event)),
        onShowPrevented: _cache[6] || (_cache[6] = ($event) => emit("show-prevented", $event)),
        onTogglePrevented: _cache[7] || (_cache[7] = ($event) => emit("toggle-prevented", $event)),
        onToggle: _cache[8] || (_cache[8] = ($event) => emit("toggle", $event)),
        onPointerleave: _cache[9] || (_cache[9] = ($event) => emit("pointerleave", $event)),
        onBlur: _cache[10] || (_cache[10] = ($event) => emit("blur", $event)),
        onClickOutside: _cache[11] || (_cache[11] = ($event) => emit("click-outside", $event)),
        onCloseOnHide: _cache[12] || (_cache[12] = ($event) => emit("close-on-hide", $event))
      }), createSlots({ _: 2 }, [
        slots.default ? {
          name: "default",
          fn: withCtx((scope) => [
            renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(scope)))
          ]),
          key: "0"
        } : void 0,
        slots.target ? {
          name: "target",
          fn: withCtx((scope) => [
            renderSlot(_ctx.$slots, "target", normalizeProps(guardReactiveProps(scope)))
          ]),
          key: "1"
        } : void 0,
        slots.title ? {
          name: "title",
          fn: withCtx((scope) => [
            renderSlot(_ctx.$slots, "title", normalizeProps(guardReactiveProps(scope)))
          ]),
          key: "2"
        } : void 0
      ]), 1040, ["modelValue"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BTooltip.vue_vue_type_script_setup_true_lang-BBsccihF.mjs.map
