const getActiveElement = (excludes = []) => {
  const { activeElement } = document;
  return activeElement && !(excludes == null ? void 0 : excludes.some((el) => el === activeElement)) ? activeElement : null;
};
const attemptFocus = (el, options = {}) => {
  const isActiveElement = (el2) => el2 === getActiveElement();
  try {
    el.focus(options);
  } catch (e) {
    console.error(e);
  }
  return isActiveElement(el);
};
const isEmptySlot = (el) => ((el == null ? void 0 : el()) ?? []).length === 0;
const isVisible = (el) => {
  if (el.getAttribute("display") === "none") {
    return false;
  }
  const bcr = el.getBoundingClientRect();
  return !!(bcr && bcr.height > 0 && bcr.width > 0);
};
const sortSlotElementsByPosition = (a, b) => {
  if (typeof Node === "undefined" || !Node || !a || !b) return 0;
  const position = a.compareDocumentPosition(b);
  if (position & Node.DOCUMENT_POSITION_FOLLOWING) return -1;
  if (position & Node.DOCUMENT_POSITION_PRECEDING) return 1;
  return 0;
};
const getModalZIndex = (element) => {
  if (typeof window === "undefined") return 1055;
  const target = element ?? document.body;
  const raw = window.getComputedStyle(target).getPropertyValue("--bs-modal-zindex").trim();
  const parsed = Number.parseInt(raw, 10);
  return Number.isFinite(parsed) ? parsed : 1055;
};
export {
  isVisible as a,
  attemptFocus as b,
  getModalZIndex as c,
  getActiveElement as g,
  isEmptySlot as i,
  sortSlotElementsByPosition as s
};
//# sourceMappingURL=dom-BNfqkuY-.mjs.map
