const IS_BROWSER = typeof window !== "undefined" && typeof document !== "undefined" && typeof navigator !== "undefined";
const parseEventOptions = (options) => {
  const HAS_PASSIVE_EVENT_SUPPORT = (() => {
    let passiveEventSupported = false;
    if (IS_BROWSER) {
      try {
        const options2 = {
          // This function will be called when the browser
          // attempts to access the passive property
          get passive() {
            passiveEventSupported = true;
            return;
          }
        };
        WINDOW.addEventListener("test", options2, options2);
        WINDOW.removeEventListener("test", options2, options2);
      } catch {
        passiveEventSupported = false;
      }
    }
    return passiveEventSupported;
  })();
  if (HAS_PASSIVE_EVENT_SUPPORT) {
    return typeof options === "object" ? options : { capture: !!options || false };
  }
  return typeof options === "object" ? options.capture : options;
};
const eventOn = (el, eventName, handler, options) => {
  if (el && el.addEventListener) {
    el.addEventListener(eventName, handler, parseEventOptions(options));
  }
};
const eventOff = (el, eventName, handler, options) => {
  if (el && el.removeEventListener) {
    el.removeEventListener(eventName, handler, options);
  }
};
const eventOnOff = (on, eventParams) => {
  const method = on ? eventOn : eventOff;
  method(...eventParams);
};
const stopEvent = (event, { preventDefault = true, propagation = false, immediatePropagation = false } = {}) => {
  if (preventDefault) {
    event.preventDefault();
  }
  if (propagation) {
    event.stopPropagation();
  }
  if (immediatePropagation) {
    event.stopImmediatePropagation();
  }
};
export {
  eventOnOff as e,
  stopEvent as s
};
//# sourceMappingURL=event-a_bi5ysw.mjs.map
