const genericBvnPrefix = "BootstrapVueNext__";
const withBvnPrefix = (value, suffix = "") => {
  const suffixWithTrail = `${suffix}___`;
  return `${genericBvnPrefix}ID__${value}__${suffix ? suffixWithTrail : ""}`;
};
const createBvnInjectionKey = (name) => withBvnPrefix(name);
const createBvnPluginInjectionKey = (name) => withBvnPrefix(`${name}__plugin`);
const carouselInjectionKey = createBvnInjectionKey("carousel");
const tabsInjectionKey = createBvnInjectionKey("tabs");
const progressInjectionKey = createBvnInjectionKey("progress");
const listGroupInjectionKey = createBvnInjectionKey("listGroup");
const avatarGroupInjectionKey = createBvnInjectionKey("avatarGroup");
const accordionInjectionKey = createBvnInjectionKey("accordion");
const checkboxGroupKey = createBvnInjectionKey("checkboxGroup");
const radioGroupKey = createBvnInjectionKey("radioGroup");
const collapseInjectionKey = createBvnInjectionKey("collapse");
const globalShowHideStorageInjectionKey = createBvnPluginInjectionKey("globalShowHideStorage");
const dropdownInjectionKey = createBvnInjectionKey("dropdown");
const navbarInjectionKey = createBvnInjectionKey("navbar");
const rtlPluginKey = createBvnPluginInjectionKey("rtl");
const breadcrumbGlobalIndexKey = `${genericBvnPrefix}global_breadcrumb`;
const breadcrumbPluginKey = createBvnPluginInjectionKey("breadcrumbPlugin");
const modalManagerPluginKey = createBvnPluginInjectionKey("modalManager");
const defaultsKey = createBvnPluginInjectionKey("defaults");
const inputGroupKey = createBvnInjectionKey("inputGroup");
const buttonGroupKey = createBvnInjectionKey("buttonGroup");
const toastPluginKey = createBvnPluginInjectionKey("toast");
const modalControllerPluginKey = createBvnPluginInjectionKey("modalController");
const popoverPluginKey = createBvnPluginInjectionKey("popover");
const formGroupPluginKey = createBvnInjectionKey("formGroupPlugin");
export {
  breadcrumbGlobalIndexKey as a,
  buttonGroupKey as b,
  collapseInjectionKey as c,
  dropdownInjectionKey as d,
  breadcrumbPluginKey as e,
  defaultsKey as f,
  globalShowHideStorageInjectionKey as g,
  modalManagerPluginKey as h,
  inputGroupKey as i,
  accordionInjectionKey as j,
  avatarGroupInjectionKey as k,
  checkboxGroupKey as l,
  modalControllerPluginKey as m,
  formGroupPluginKey as n,
  radioGroupKey as o,
  popoverPluginKey as p,
  listGroupInjectionKey as q,
  rtlPluginKey as r,
  progressInjectionKey as s,
  toastPluginKey as t,
  tabsInjectionKey as u,
  carouselInjectionKey as v,
  withBvnPrefix as w,
  navbarInjectionKey as x
};
//# sourceMappingURL=keys-CwytVEYF.mjs.map
