import { inject, computed, toValue, watch } from "vue";
import { a as breadcrumbGlobalIndexKey, e as breadcrumbPluginKey } from "../../../keys-CwytVEYF.mjs";
const useBreadcrumb = (id = breadcrumbGlobalIndexKey) => {
  const parentData = inject(breadcrumbPluginKey);
  const resolvedId = computed(() => {
    const v = toValue(id);
    if (!v) return breadcrumbGlobalIndexKey;
    return v;
  });
  watch(
    resolvedId,
    (newValue) => {
      if (!newValue || !parentData) return;
      parentData.items.value = {
        ...parentData.items.value,
        [newValue]: parentData.items.value[newValue] || []
      };
    },
    { immediate: true }
  );
  const items = computed({
    get: () => (parentData == null ? void 0 : parentData.items.value[resolvedId.value]) || [],
    set(value) {
      if (!parentData) return;
      parentData.items.value[resolvedId.value] = value;
    }
  });
  return {
    items,
    reset() {
      if (!parentData) return;
      parentData.reset(resolvedId.value || void 0);
    }
  };
};
export {
  useBreadcrumb
};
//# sourceMappingURL=index.mjs.map
