import { inject, ref, getCurrentInstance, computed, toValue } from "vue";
import { m as modalControllerPluginKey } from "../../../keys-CwytVEYF.mjs";
import { u as useSharedModalStack } from "../../../useModalManager-BiAG_iTr.mjs";
const useModalController = () => {
  const noopPromise = () => {
    console.warn(
      "useModalController() was called outside of the setup() function! or the plugin is not provided."
    );
    return Promise.resolve(null);
  };
  const modalControllerPlugin = inject(modalControllerPluginKey, {
    modals: ref(/* @__PURE__ */ new Map()),
    _isOrchestratorInstalled: ref(false),
    create: noopPromise,
    show: noopPromise,
    confirm: noopPromise
  });
  if (modalControllerPlugin.create === noopPromise) {
    throw Error(
      "useModalController() was called outside of the setup() function! or the plugin is not provided."
    );
  }
  const { lastStack, stack, registry } = useSharedModalStack();
  const hide = (trigger, id) => {
    var _a, _b, _c;
    if (id === void 0) {
      if (id === void 0 && (lastStack == null ? void 0 : lastStack.value)) {
        (_a = lastStack == null ? void 0 : lastStack.value.exposed) == null ? void 0 : _a.hide(trigger);
      }
    } else {
      const stackModal = stack == null ? void 0 : stack.value.find((modal2) => {
        var _a2;
        return ((_a2 = modal2.exposed) == null ? void 0 : _a2.id) === id;
      });
      if (stackModal) {
        (_b = stackModal.exposed) == null ? void 0 : _b.hide(trigger);
        return;
      }
      const modal = modalControllerPlugin.modals.value.get(id);
      if (modal) {
        modal.modelValue = false;
        (_c = modal["onUpdate:modelValue"]) == null ? void 0 : _c.call(modal, false);
      } else {
        stack == null ? void 0 : stack.value.forEach((modal2) => {
          var _a2, _b2;
          if (((_a2 = modal2.exposed) == null ? void 0 : _a2.id) === id) {
            (_b2 = modal2.exposed) == null ? void 0 : _b2.hide(trigger, true);
          }
        });
      }
    }
  };
  const hideAll = (trigger) => {
    stack == null ? void 0 : stack.value.forEach((modal) => {
      var _a;
      (_a = modal.exposed) == null ? void 0 : _a.hide(trigger, true);
    });
  };
  const get = (id) => {
    var _a;
    if (modalControllerPlugin.modals.value.get(id)) {
      const modal = modalControllerPlugin.modals.value.get(id);
      return {
        modal,
        show() {
          modal == null ? void 0 : modal.promise.value.show();
        },
        hide(trigger) {
          modal == null ? void 0 : modal.promise.value.hide(trigger);
        }
      };
    }
    if (registry == null ? void 0 : registry.value) {
      for (const [, modal] of (registry == null ? void 0 : registry.value.entries()) ?? []) {
        if (toValue((_a = modal.exposed) == null ? void 0 : _a.id) === id) {
          return {
            modal,
            show() {
              var _a2;
              (_a2 = modal.exposed) == null ? void 0 : _a2.show();
            },
            hide(trigger) {
              var _a2;
              (_a2 = modal.exposed) == null ? void 0 : _a2.hide(trigger, true);
            }
          };
        }
      }
    }
    return null;
  };
  const instance = getCurrentInstance();
  const current = () => {
    const findBModal = (component) => {
      if (!component.parent) {
        return null;
      }
      if (component.parent.type.__name === "BModal") {
        return component.parent;
      }
      return findBModal(component.parent);
    };
    if (!instance) {
      return null;
    }
    const modalComponent = computed(() => findBModal(instance));
    const modal = computed(() => {
      var _a;
      return (_a = modalComponent.value) == null ? void 0 : _a.proxy;
    });
    return {
      show() {
        var _a, _b;
        (_b = (_a = modalComponent.value) == null ? void 0 : _a.exposed) == null ? void 0 : _b.show();
      },
      hide(trigger) {
        var _a, _b;
        (_b = (_a = modalComponent.value) == null ? void 0 : _a.exposed) == null ? void 0 : _b.hide(trigger, true);
      },
      modal
    };
  };
  return {
    hide,
    hideAll,
    get,
    current,
    ...modalControllerPlugin
    // Todo: Supports listening events globally in the future
  };
};
export {
  useModalController
};
//# sourceMappingURL=index.mjs.map
