import { inject, ref } from "vue";
import { p as popoverPluginKey } from "../../../keys-CwytVEYF.mjs";
const usePopoverController = () => {
  const noopPromise = () => {
    console.warn(
      "usePopoverController() was called outside of the setup() function! or the plugin is not provided."
    );
    return Promise.resolve(null);
  };
  const popoverControllerPlugin = inject(popoverPluginKey, {
    popovers: ref(/* @__PURE__ */ new Map()),
    popover: noopPromise,
    tooltip: noopPromise,
    _isOrchestratorInstalled: ref(false)
  });
  if (popoverControllerPlugin.popover === noopPromise) {
    throw new Error(
      "usePopoverController() was called outside of the setup() function! or the plugin is not provided."
    );
  }
  return {
    ...popoverControllerPlugin
  };
};
export {
  usePopoverController
};
//# sourceMappingURL=index.mjs.map
