import { EmitFn, Ref } from 'vue';
import { BvTriggerableEvent } from '../utils';
export declare const fadeBaseTransitionProps: {
    name: string;
    enterActiveClass: string;
    enterFromClass: string;
    enterToClass: string;
    leaveActiveClass: string;
    leaveFromClass: string;
    leaveToClass: string;
    css: boolean;
};
interface TransitionProps {
    onBeforeEnter?: (el: Element) => void;
    onEnter?: (el: Element) => void;
    onAfterEnter?: (el: Element) => void;
    onBeforeLeave?: (el: Element) => void;
    onLeave?: (el: Element) => void;
    onAfterLeave?: (el: Element) => void;
    enterToClass?: string;
    leaveToClass?: string;
    enterFromClass?: string;
    leaveFromClass?: string;
    enterActiveClass?: string;
    leaveActiveClass?: string;
}
export declare const useShowHide: (modelValue: Ref<boolean | number>, props: {
    visible?: boolean;
    show?: boolean;
    noAnimation?: boolean;
    noFade?: boolean;
    noCloseOnBackdrop?: boolean;
    noCloseOnEsc?: boolean;
    transitionProps?: TransitionProps;
    lazy?: boolean;
    initialAnimation?: boolean;
    delay?: number | {
        show: number;
        hide: number;
    };
} & Record<string, unknown>, emit: EmitFn, element: Ref<HTMLElement | null>, computedId: Ref<string>, options?: {
    transitionProps?: TransitionProps;
    showFn?: () => void;
    hideFn?: () => void;
}) => {
    showRef: Ref<boolean, boolean>;
    renderRef: Ref<boolean, boolean>;
    renderBackdropRef: Ref<boolean, boolean>;
    isVisible: Ref<boolean, boolean>;
    isActive: Ref<boolean, boolean>;
    trapActive: Ref<boolean, boolean>;
    show: (resolveOnHide?: boolean) => Promise<boolean | string>;
    hide: (trigger?: string, noTriggerEmit?: boolean) => Promise<string>;
    toggle: (resolveOnHide?: boolean) => Promise<boolean | string>;
    throttleHide: import('../../node_modules/@vueuse/shared').PromisifyFn<(a: any) => Promise<string>>;
    throttleShow: import('../../node_modules/@vueuse/shared').PromisifyFn<() => Promise<string | boolean>>;
    buildTriggerableEvent: (type: string, opts?: Readonly<Partial<BvTriggerableEvent>>) => BvTriggerableEvent;
    computedNoAnimation: import('vue').ComputedRef<boolean>;
    localNoAnimation: Ref<boolean, boolean>;
    localTemporaryHide: Ref<boolean, boolean>;
    isLeaving: Ref<boolean, boolean>;
    transitionProps: {
        onBeforeEnter: (el: Element) => void;
        onEnter: (el: Element) => void;
        onAfterEnter: (el: Element) => void;
        onBeforeLeave: (el: Element) => void;
        onLeave: (el: Element) => void;
        onAfterLeave: (el: Element) => void;
        enterToClass: string;
        leaveToClass: string;
        enterFromClass: string;
        leaveFromClass: string;
        enterActiveClass: string;
        leaveActiveClass: string;
        name: string;
        css: boolean;
    };
    lazyLoadCompleted: Ref<boolean, boolean>;
    markLazyLoadCompleted: () => void;
    contentShowing: import('vue').ComputedRef<boolean>;
    backdropReady: Ref<boolean, boolean>;
    backdropVisible: Ref<boolean, boolean>;
    backdropTransitionProps: {
        onBeforeEnter: () => void;
        onAfterEnter: () => void;
        onBeforeLeave: () => void;
        onAfterLeave: () => void;
        name: string;
        enterActiveClass: string;
        enterFromClass: string;
        enterToClass: string;
        leaveActiveClass: string;
        leaveFromClass: string;
        leaveToClass: string;
        css: boolean;
    };
};
export {};
