import { inject, ref } from "vue";
import { t as toastPluginKey } from "../../../keys-CwytVEYF.mjs";
const useToastController = () => {
  const noopPromise = () => {
    console.warn(
      "useToastController() was called outside of the setup() function! or the plugin is not provided."
    );
    return Promise.resolve(null);
  };
  const toastContollerPlugin = inject(toastPluginKey, {
    toasts: ref([]),
    create: noopPromise,
    /*
      @deprecated
      */
    show: noopPromise,
    _isAppend: ref(false),
    _isOrchestratorInstalled: ref(false)
  });
  if (toastContollerPlugin.create === noopPromise) {
    throw new Error(
      "useToastController() was called outside of the setup() function! or the plugin is not provided."
    );
  }
  return {
    ...toastContollerPlugin
  };
};
export {
  useToastController
};
//# sourceMappingURL=index.mjs.map
