import { getCurrentInstance, inject, computed, toValue } from "vue";
import { g as globalShowHideStorageInjectionKey } from "../../../keys-CwytVEYF.mjs";
const useToggle = (id = void 0) => {
  const instance = getCurrentInstance();
  const storage = inject(globalShowHideStorageInjectionKey, null);
  if (!storage) {
    throw new Error(
      "useToggle() was called outside of the setup() function or the showHide plugin is not provided."
    );
  }
  const registry = storage.values;
  const findComponent = (component) => {
    var _a;
    if (!component.parent) {
      return null;
    }
    if (((_a = component.parent.exposed) == null ? void 0 : _a["id"]) && registry.value.get(toValue(component.parent.exposed.id))) {
      return component.parent;
    }
    return findComponent(component.parent);
  };
  const myComponent = computed(() => {
    var _a;
    const resolvedId = toValue(id);
    if (!registry) return null;
    if (resolvedId) {
      const value = registry.value.get(resolvedId);
      return toValue(value) || null;
    }
    if (!instance) {
      return null;
    }
    const component = findComponent(instance);
    return toValue(registry.value.get(toValue((_a = component == null ? void 0 : component.exposed) == null ? void 0 : _a.id))) || null;
  });
  return {
    value: computed(() => {
      var _a;
      return (_a = myComponent.value) == null ? void 0 : _a.value;
    }),
    show: (resolveOnHide) => {
      var _a;
      return ((_a = myComponent.value) == null ? void 0 : _a.show(resolveOnHide)) || Promise.reject("not found");
    },
    hide: (trigger) => {
      var _a;
      return ((_a = myComponent.value) == null ? void 0 : _a.hide(trigger, true)) || Promise.reject("not found");
    },
    toggle: (resolveOnHide) => {
      var _a;
      return ((_a = myComponent.value) == null ? void 0 : _a.toggle(resolveOnHide)) || Promise.reject("not found");
    },
    component: computed(() => {
      var _a;
      return (_a = myComponent.value) == null ? void 0 : _a.component;
    })
  };
};
export {
  useToggle
};
//# sourceMappingURL=index.mjs.map
