import "vue";
import { d as unbind, e as resolveActiveStatus, g as resolveContent, h as bind, j as resolveDirectiveProps } from "../../../floatingUi-BQpU1TSt.mjs";
import { f as defaultsKey } from "../../../keys-CwytVEYF.mjs";
import { f as findProvides } from "../../../utils-DPq73bs8.mjs";
const vBTooltip = {
  mounted(el, binding, vnode) {
    var _a;
    const defaults = (_a = findProvides(binding, vnode)[defaultsKey]) == null ? void 0 : _a.value;
    const isActive = resolveActiveStatus(binding.value);
    if (!isActive) return;
    const text = resolveContent(binding.value, el);
    if (!text.body && !text.title) return;
    el.$__binding = JSON.stringify([binding.modifiers, binding.value]);
    bind(el, binding, {
      noninteractive: true,
      ...defaults["BTooltip"] || void 0,
      ...resolveDirectiveProps(binding, el),
      title: text.title ?? text.body ?? "",
      tooltip: isActive
    });
  },
  updated(el, binding, vnode) {
    var _a;
    const defaults = (_a = findProvides(binding, vnode)[defaultsKey]) == null ? void 0 : _a.value;
    const isActive = resolveActiveStatus(binding.value);
    if (!isActive) return;
    const text = resolveContent(binding.value, el);
    if (!text.body && !text.title) return;
    delete binding.oldValue;
    if (el.$__binding === JSON.stringify([binding.modifiers, binding.value])) return;
    unbind(el);
    bind(el, binding, {
      noninteractive: true,
      ...defaults["BTooltip"] || void 0,
      ...resolveDirectiveProps(binding, el),
      title: text.title ?? text.body ?? "",
      tooltip: isActive
    });
    el.$__binding = JSON.stringify([binding.modifiers, binding.value]);
  },
  beforeUnmount(el) {
    unbind(el);
  }
};
export {
  vBTooltip
};
//# sourceMappingURL=index.mjs.map
