import { breadcrumbPlugin } from "../breadcrumb/index.mjs";
import { bootstrapPlugin } from "../bootstrap/index.mjs";
import { modalControllerPlugin } from "../modalController/index.mjs";
import { modalManagerPlugin } from "../modalManager/index.mjs";
import { popoverPlugin } from "../popoverController/index.mjs";
import { rtlPlugin } from "../rtl/index.mjs";
import { toastPlugin } from "../toastController/index.mjs";
import { showHidePlugin } from "../showHide/index.mjs";
const createBootstrap = (pluginData = {}) => ({
  install(app) {
    if (pluginData.breadcrumb ?? true) {
      app.use(breadcrumbPlugin);
    }
    if (pluginData.modalController ?? true) {
      app.use(modalControllerPlugin);
    }
    if (pluginData.modalManager ?? true) {
      app.use(modalManagerPlugin);
    }
    if ((pluginData.rtl ?? true) || typeof pluginData.rtl === "object") {
      app.use(rtlPlugin, pluginData);
    }
    if (pluginData.toast ?? true) {
      app.use(toastPlugin);
    }
    if (pluginData.popover ?? true) {
      app.use(popoverPlugin);
    }
    app.use(showHidePlugin);
    app.use(bootstrapPlugin, pluginData);
  }
});
export {
  createBootstrap
};
//# sourceMappingURL=index.mjs.map
