import { ref, toValue, isRef, markRaw, toRef, watch, isReadonly, onScopeDispose, nextTick } from "vue";
import { m as modalControllerPluginKey } from "../../../keys-CwytVEYF.mjs";
const modalControllerPlugin = {
  install(app) {
    const modals = ref(/* @__PURE__ */ new Map());
    const _isOrchestratorInstalled = ref(false);
    const buildPromise = (_id) => {
      let resolveFunc = () => {
      };
      const promise = new Promise((resolve) => {
        resolveFunc = resolve;
      });
      Object.assign(promise, {
        id: _id,
        ref: null,
        show() {
          if (!this.ref) return this.set({ modelValue: true });
          this.ref.show();
          return promise;
        },
        hide(trigger) {
          if (!this.ref) return this.set({ modelValue: false });
          this.ref.hide(trigger, true);
          return promise;
        },
        toggle() {
          var _a;
          if (!this.ref) return this.set({ modelValue: !((_a = this.get()) == null ? void 0 : _a.modelValue) });
          this.ref.toggle();
          return promise;
        },
        get() {
          return modals.value.get(_id);
        },
        set(val) {
          var _a;
          const modal = modals.value.get(_id);
          if (modal) {
            const v = { ...toValue(modal), ...toValue(val) };
            if (modal.modelValue !== v.modelValue) {
              (_a = modal["onUpdate:modelValue"]) == null ? void 0 : _a.call(modal, v.modelValue);
            }
            modals.value.set(_id, {
              ...v,
              title: toValue(v.title),
              body: toValue(v.body),
              modelValue: toValue(v.modelValue)
            });
          }
          return promise;
        },
        async destroy() {
          var _a, _b;
          const modal = modals.value.get(_id);
          if (!modal) return;
          (_b = (_a = modal.promise).stop) == null ? void 0 : _b.call(_a);
          if (modal.modelValue) {
            await new Promise((resolve) => {
              modal.modelValue = false;
              const prev = modal["onHidden"];
              modal["onHidden"] = (e) => {
                prev == null ? void 0 : prev(e);
                resolve(e);
              };
              nextTick(() => {
                var _a2;
                (_a2 = modal["onUpdate:modelValue"]) == null ? void 0 : _a2.call(modal, false);
              });
            });
          }
          modals.value.delete(_id);
        },
        async [Symbol.asyncDispose]() {
          await this.destroy();
        }
      });
      return {
        value: promise,
        resolve: resolveFunc
      };
    };
    const create = (obj = {}, options = {}) => {
      var _a;
      if (!_isOrchestratorInstalled.value) {
        throw new Error(
          "The BModalOrchestrator component must be mounted to use the modal controller"
        );
      }
      const { component, slots } = toValue(obj);
      if (component) {
        if (isRef(obj)) obj.value.component = markRaw(component);
        else if (typeof obj === "object") obj.component = markRaw(component);
      }
      if (slots) {
        if (isRef(obj)) obj.value.slots = markRaw(slots);
        else if (typeof obj === "object") obj.slots = markRaw(slots);
      }
      const resolvedProps = toRef(obj);
      const _self = ((_a = resolvedProps.value) == null ? void 0 : _a.id) || Symbol("Modals controller");
      const promise = buildPromise(_self);
      promise.stop = watch(
        resolvedProps,
        (_newValue) => {
          const newValue = { ...toValue(_newValue) };
          const previous = modals.value.get(_self);
          const v = {
            ...previous || {}
          };
          if (newValue.props) {
            Object.assign(v, newValue.props);
            newValue.props = void 0;
          }
          for (const key in newValue) {
            if (key.startsWith("on")) {
              v[key] = newValue[key];
            } else {
              v[key] = toValue(
                newValue[key]
              );
            }
          }
          modals.value.set(_self, {
            ...v,
            ...v.modelValue === void 0 && { modelValue: true },
            "onUpdate:modelValue": (val) => {
              var _a2;
              (_a2 = newValue["onUpdate:modelValue"]) == null ? void 0 : _a2.call(newValue, val);
              const { modelValue } = toValue(obj);
              if (isRef(obj) && !isRef(modelValue)) obj.value.modelValue = val;
              if (isRef(modelValue) && !isReadonly(modelValue)) {
                modelValue.value = val;
              }
              const modal = modals.value.get(_self);
              if (modal) {
                modals.value.set(_self, {
                  ...modal,
                  modelValue: val
                });
              }
            },
            options,
            promise
          });
        },
        {
          immediate: true,
          deep: true
        }
      );
      onScopeDispose(() => {
        var _a2, _b;
        const modal = modals.value.get(_self);
        if (modal) {
          (_b = (_a2 = modal.promise.value).destroy) == null ? void 0 : _b.call(_a2);
        }
      }, true);
      return promise.value;
    };
    const show = (obj = {}) => {
      console.warn(
        "[BootstrapVueNext] useModalController: The show() method is deprecated. Use create({}).show() instead."
      );
      return create(obj, { returnBoolean: true }).show();
    };
    const confirm = (obj = {}) => {
      console.warn(
        "[BootstrapVueNext] useModalController: The confirm() method is deprecated. Use create({}).show() instead."
      );
      return create(obj, { returnBoolean: true }).show();
    };
    app.provide(modalControllerPluginKey, {
      _isOrchestratorInstalled,
      create,
      modals,
      show,
      confirm
    });
  }
};
export {
  modalControllerPlugin
};
//# sourceMappingURL=index.mjs.map
