import { ComponentResolver } from 'unplugin-vue-components';
import { ComponentType, ConfigurationOption, DirectiveType } from '../types/BootstrapVueOptions';
/**
 * Resolver for unplugin-vue-components
 *
 * Contains two hidden properties `__usedComponents` and `__usedDirectives` (both are `Set<string>`)
 * which are used to get the list of used components and directives.. You can use this list of used components.
 * It may not be fully accurate. It can be used to get a list of stuff to trim down, like css
 * @example
 * ```ts
 * const bootstrapVueNextResolver = BootstrapVueNextResolver()
 * console.info(bootstrapVueNextResolver.__usedComponents)
 * console.info(bootstrapVueNextResolver.__usedDirectives)
 *
 * // ... blah blah blah, `plugins: [Components({resolvers: [bootstrapVueNextResolver]})]` ...
 * ```
 */
export declare const BootstrapVueNextResolver: (({ aliases, directives, components, }?: Readonly<{
    components?: boolean | ConfigurationOption<ComponentType>;
    directives?: boolean | ConfigurationOption<DirectiveType>;
    aliases?: Record<string, ComponentType>;
}>) => ComponentResolver[]) & {
    __usedComponents: Set<string>;
    __usedDirectives: Set<string>;
};
