import { MaybeRefOrGetter } from 'vue';
import { DebounceFilterOptions, FunctionArgs, UseDebounceFnReturn } from '@vueuse/core';
export declare const noop: () => void;
/**
 * Debounce execution of a function.
 *
 * @see https://vueuse.org/useDebounceFn
 * @param  fn          A function to be executed after delay milliseconds debounced.
 * @param  ms          A zero-or-greater delay in milliseconds. For event callbacks, values around 100 or 250 (or even higher) are most useful.
 * @param  options     Options
 *
 * @return A new, debounce, function, provided with a cancel method.
 */
export declare function useDebounceFn<T extends FunctionArgs>(fn: T, ms?: MaybeRefOrGetter<number>, options?: DebounceFilterOptions): UseDebounceFnReturn<T> & {
    cancel: () => void;
};
