import { ComponentInternalInstance, ComputedRef, InjectionKey, Ref, ShallowRef } from 'vue';
import { TabType } from '../types/Tab';
import { ClassValue } from '../types/AnyValuedAttributes';
import { Numberish, ValidationState } from '../types/CommonTypes';
import { LiteralUnion } from '../types/LiteralUnion';
import { Size } from '../types/Size';
import { RadiusElement } from '../types/RadiusElement';
import { BgColorVariant, ButtonVariant, ColorVariant, TextColorVariant } from '../types/ColorTypes';
import { CheckboxValue } from '../types/CheckboxTypes';
import { RadioValue } from '../types/RadioTypes';
import { BreadcrumbItemRaw } from '../types/BreadcrumbTypes';
import { ControllerKey, ModalOrchestratorCreateOptions, ModalOrchestratorCreateParam, ModalOrchestratorMapValue, PopoverOrchestratorCreateParam, PopoverOrchestratorMapValue, PromiseWithModal, PromiseWithModalBoolean, PromiseWithPopover, PromiseWithToast, ToastOrchestratorArrayValue, ToastOrchestratorCreateOptions, ToastOrchestratorCreateParam, TooltipOrchestratorCreateParam } from '../types/ComponentOrchestratorTypes';
import { BvnComponentProps } from '../types/BootstrapVueOptions';
export declare const genericBvnPrefix = "BootstrapVueNext__";
export declare const withBvnPrefix: (value: string, suffix?: string) => string;
export declare const carouselInjectionKey: InjectionKey<{
    background: Readonly<Ref<string | undefined>>;
    width: Readonly<Ref<string | undefined>>;
    height: Readonly<Ref<string | undefined>>;
}>;
export declare const tabsInjectionKey: InjectionKey<{
    lazy: Readonly<Ref<boolean>>;
    card: Readonly<Ref<boolean>>;
    noFade: Readonly<Ref<boolean>>;
    registerTab: (tab: ComputedRef<TabType>) => string;
    unregisterTab: (id: string) => void;
    activateTab: (id: string | undefined) => void;
    activeTabClass: Readonly<Ref<ClassValue>>;
    inactiveTabClass: Readonly<Ref<ClassValue>>;
    tabClass: Readonly<Ref<ClassValue>>;
    activeId: Readonly<Ref<string | undefined>>;
}>;
export declare const progressInjectionKey: InjectionKey<{
    animated: Readonly<Ref<boolean | undefined>>;
    max: Readonly<Ref<Numberish>>;
    showProgress: Readonly<Ref<boolean | undefined>>;
    showValue: Readonly<Ref<boolean | undefined>>;
    striped: Readonly<Ref<boolean | undefined>>;
}>;
export declare const listGroupInjectionKey: InjectionKey<{
    numbered: Readonly<Ref<boolean>>;
}>;
export declare const avatarGroupInjectionKey: InjectionKey<{
    overlapScale: Readonly<Ref<number>>;
    size: Readonly<Ref<LiteralUnion<Size, Numberish> | undefined>>;
    square: Readonly<Ref<boolean>>;
    rounded: Readonly<Ref<RadiusElement | boolean>>;
    roundedTop: Readonly<Ref<RadiusElement | boolean | undefined>>;
    roundedBottom: Readonly<Ref<RadiusElement | boolean | undefined>>;
    roundedStart: Readonly<Ref<RadiusElement | boolean | undefined>>;
    roundedEnd: Readonly<Ref<RadiusElement | boolean | undefined>>;
    variant: Readonly<Ref<ColorVariant | null>>;
    bgVariant: Readonly<Ref<BgColorVariant | null>>;
    textVariant: Readonly<Ref<TextColorVariant | null>>;
}>;
export declare const accordionInjectionKey: InjectionKey<{
    openItem: Readonly<Ref<string | string[] | undefined>>;
    free: Readonly<Ref<boolean>>;
    initialAnimation: Readonly<Ref<boolean>>;
    lazy: Readonly<Ref<boolean>>;
    unmountLazy: Readonly<Ref<boolean>>;
    setOpenItem: (id: string) => void;
    setCloseItem: (id: string) => void;
    registerAccordionItem: (id: string, el: Readonly<ShallowRef<HTMLElement | null>>) => void;
    unregisterAccordionItem: (id: string) => void;
}>;
export declare const checkboxGroupKey: InjectionKey<{
    modelValue: Ref<readonly CheckboxValue[]>;
    switch: Readonly<Ref<boolean>>;
    buttonVariant: Readonly<Ref<ButtonVariant | null>>;
    form: Readonly<Ref<string | undefined>>;
    name: Readonly<Ref<string>>;
    state: Readonly<Ref<ValidationState | undefined>>;
    plain: Readonly<Ref<boolean>>;
    size: Readonly<Ref<Size>>;
    inline: Readonly<Ref<boolean>>;
    reverse: Readonly<Ref<boolean>>;
    required: Readonly<Ref<boolean>>;
    buttons: Readonly<Ref<boolean>>;
    disabled: Readonly<Ref<boolean>>;
}>;
export declare const radioGroupKey: InjectionKey<{
    modelValue: Ref<RadioValue>;
    buttonVariant: Readonly<Ref<ButtonVariant | null>>;
    form: Readonly<Ref<string | undefined>>;
    name: Readonly<Ref<string>>;
    buttons: Readonly<Ref<boolean>>;
    state: Readonly<Ref<ValidationState | undefined>>;
    plain: Readonly<Ref<boolean>>;
    size: Readonly<Ref<Size>>;
    inline: Readonly<Ref<boolean>>;
    reverse: Readonly<Ref<boolean>>;
    required: Readonly<Ref<boolean>>;
    disabled: Readonly<Ref<boolean>>;
}>;
export declare const collapseInjectionKey: InjectionKey<{
    id?: Readonly<Ref<string>>;
    readonly hide?: () => void;
    readonly show?: () => void;
    readonly toggle?: () => void;
    visible?: Readonly<Ref<boolean>>;
    isNav?: Readonly<Ref<boolean>>;
}>;
export type RegisterShowHideFnInput = {
    id: string;
    component: ComponentInternalInstance;
    value: Ref<boolean>;
    toggle: (resolveOnHide?: boolean) => Promise<boolean | string>;
    show: (resolveOnHide?: boolean) => Promise<boolean | string>;
    hide: (trigger?: string) => Promise<boolean | string>;
    registerTrigger: (trigger: string, el: Element) => void;
    unregisterTrigger: (trigger: string, el: Element, clean: boolean) => void;
};
export interface RegisterShowHideMapValue {
    id: string;
    component: ComponentInternalInstance;
    value: Readonly<Ref<boolean>>;
    toggle: (resolveOnHide?: boolean) => Promise<boolean | string | null>;
    show: (resolveOnHide?: boolean) => Promise<boolean | string | null>;
    hide: (trigger?: string, noTraverse?: boolean) => Promise<boolean | string | null>;
    registerTrigger: (trigger: string, el: Element) => void;
    unregisterTrigger: (trigger: string, el: Element, clean: boolean) => void;
}
export interface RegisterShowHideValue {
    register: (input: RegisterShowHideFnInput) => {
        unregister: () => void;
        updateId: (newId: string, oldId: string) => void;
    };
    values: Ref<Map<string, RegisterShowHideMapValue>>;
}
export declare const globalShowHideStorageInjectionKey: InjectionKey<RegisterShowHideValue>;
export declare const dropdownInjectionKey: InjectionKey<{
    id?: Readonly<Ref<string>>;
    readonly hide?: () => void;
    readonly show?: () => void;
    readonly toggle?: () => void;
    visible?: Readonly<Ref<boolean>>;
    isNav?: Readonly<Ref<boolean>>;
}>;
export declare const navbarInjectionKey: InjectionKey<{
    tag?: Readonly<Ref<string>>;
    autoClose?: Readonly<Ref<boolean>>;
}>;
export declare const rtlPluginKey: InjectionKey<{
    isRtl: Ref<boolean>;
    locale: Ref<string | undefined>;
}>;
export declare const breadcrumbGlobalIndexKey = "BootstrapVueNext__global_breadcrumb";
export declare const breadcrumbPluginKey: InjectionKey<{
    items: Ref<Record<string, BreadcrumbItemRaw[]>>;
    reset: (key?: string) => void;
}>;
export declare const modalManagerPluginKey: InjectionKey<{
    stack: ComputedRef<ComponentInternalInstance[]>;
    countStack: ComputedRef<number>;
    lastStack: ComputedRef<ComponentInternalInstance | undefined>;
    pushStack: (modal: Readonly<ComponentInternalInstance>) => void;
    removeStack: (modal: Readonly<ComponentInternalInstance>) => void;
    registry: Readonly<Ref<Map<number, ComponentInternalInstance>>>;
    pushRegistry: (modal: Readonly<ComponentInternalInstance>) => void;
    removeRegistry: (modal: Readonly<ComponentInternalInstance>) => void;
}>;
export declare const defaultsKey: InjectionKey<Ref<Partial<BvnComponentProps>>>;
export declare const inputGroupKey: InjectionKey<boolean>;
export declare const buttonGroupKey: InjectionKey<boolean>;
export declare const toastPluginKey: InjectionKey<{
    toasts: Ref<ToastOrchestratorArrayValue[]>;
    _isAppend: Ref<boolean>;
    _isOrchestratorInstalled: Ref<boolean>;
    create: (obj: ToastOrchestratorCreateParam, options?: ToastOrchestratorCreateOptions) => PromiseWithToast;
    /**
     * show
     * @deprecated
     */
    show: (obj: ToastOrchestratorCreateParam) => PromiseWithToast;
}>;
export declare const modalControllerPluginKey: InjectionKey<{
    modals: Ref<Map<ControllerKey, ModalOrchestratorMapValue>>;
    _isOrchestratorInstalled: Ref<boolean>;
    create: (obj: ModalOrchestratorCreateParam, options?: ModalOrchestratorCreateOptions) => PromiseWithModal | PromiseWithModalBoolean;
    /**
     * show
     * @deprecated
     */
    show: (obj: ModalOrchestratorCreateParam) => PromiseWithModalBoolean;
    /**
     * show
     * @deprecated
     */
    confirm: (obj: ModalOrchestratorCreateParam) => PromiseWithModalBoolean;
}>;
export declare const popoverPluginKey: InjectionKey<{
    popovers: Ref<Map<ControllerKey, PopoverOrchestratorMapValue>>;
    popover: (obj: PopoverOrchestratorCreateParam) => PromiseWithPopover;
    tooltip: (obj: TooltipOrchestratorCreateParam) => PromiseWithPopover;
    _isOrchestratorInstalled: Ref<boolean>;
}>;
export declare const formGroupPluginKey: InjectionKey<(id: Ref<string>) => {
    state: Readonly<Ref<ValidationState | undefined>>;
}>;
