import { toValue, ref, inject, computed, onMounted, onActivated, nextTick } from "vue";
import { u as useAriaInvalid } from "./useAriaInvalid-BTUbGj3Y.mjs";
import { u as useId } from "./useId-vZvGlR-1.mjs";
import { u as useFocus } from "./index-Ddaqsxfw.mjs";
import { n as formGroupPluginKey } from "./keys-CwytVEYF.mjs";
import { u as useStateClass } from "./useStateClass-BGbSLWFN.mjs";
import { u as useToNumber } from "./index-CYfoub2y.mjs";
const normalizeInput = (v, modelModifiers) => {
  if (v === null) return;
  let update = v;
  if (modelModifiers.number && typeof update === "string" && update !== "") {
    const parsed = Number.parseFloat(update);
    update = Number.isNaN(parsed) ? update : parsed;
  }
  return update;
};
const noop = () => {
};
function createFilterWrapper(filter, fn) {
  function wrapper(...args) {
    return new Promise((resolve, reject) => {
      Promise.resolve(filter(() => fn.apply(this, args), { fn, thisArg: this, args })).then(resolve).catch(reject);
    });
  }
  wrapper.cancel = filter.cancel;
  return wrapper;
}
function debounceFilter(ms, options = {}) {
  let timer;
  let maxTimer;
  let lastRejector = noop;
  const _clearTimeout = (timer2) => {
    clearTimeout(timer2);
    lastRejector();
    lastRejector = noop;
  };
  let lastInvoker;
  const filter = (invoke) => {
    const duration = toValue(ms);
    const maxDuration = toValue(options.maxWait);
    if (timer) _clearTimeout(timer);
    if (duration <= 0 || maxDuration !== void 0 && maxDuration <= 0) {
      if (maxTimer) {
        _clearTimeout(maxTimer);
        maxTimer = null;
      }
      return Promise.resolve(invoke());
    }
    return new Promise((resolve, reject) => {
      lastRejector = options.rejectOnCancel ? reject : resolve;
      lastInvoker = invoke;
      if (maxDuration && !maxTimer) {
        maxTimer = setTimeout(() => {
          if (timer) _clearTimeout(timer);
          maxTimer = null;
          resolve(lastInvoker());
        }, maxDuration);
      }
      timer = setTimeout(() => {
        if (maxTimer) _clearTimeout(maxTimer);
        maxTimer = null;
        resolve(invoke());
      }, duration);
    });
  };
  filter.cancel = () => {
    if (timer) _clearTimeout(timer);
    if (maxTimer) _clearTimeout(maxTimer);
    maxTimer = null;
  };
  return filter;
}
function useDebounceFn(fn, ms = 200, options = {}) {
  return createFilterWrapper(debounceFilter(ms, options), fn);
}
const useFormInput = (props, input, modelValue, modelModifiers) => {
  var _a;
  const forceUpdateKey = ref(0);
  const computedId = useId(() => props.id, "input");
  const debounceNumber = useToNumber(() => props.debounce ?? 0, { nanToZero: true });
  const debounceMaxWaitNumber = useToNumber(() => props.debounceMaxWait ?? NaN);
  const formGroupData = (_a = inject(formGroupPluginKey, null)) == null ? void 0 : _a(computedId);
  const computedState = computed(
    () => props.state !== void 0 ? props.state : (formGroupData == null ? void 0 : formGroupData.state.value) ?? null
  );
  const computedAriaInvalid = useAriaInvalid(() => props.ariaInvalid, computedState);
  const stateClass = useStateClass(computedState);
  const internalUpdateModelValue = useDebounceFn(
    (value) => {
      modelValue.value = value;
    },
    () => modelModifiers.lazy === true ? 0 : debounceNumber.value,
    { maxWait: () => modelModifiers.lazy === true ? NaN : debounceMaxWaitNumber.value }
  );
  const updateModelValue = (value, force = false, immediate = false) => {
    if (modelModifiers.lazy === true && force === false) return;
    if (immediate) {
      modelValue.value = value;
    } else {
      internalUpdateModelValue(value);
    }
  };
  const { focused } = useFocus(input, {
    initialValue: props.autofocus
  });
  const _formatValue = (value, evt, force = false) => {
    if (props.formatter !== void 0 && (!props.lazyFormatter || force)) {
      return props.formatter(value, evt);
    }
    return value;
  };
  onMounted(() => {
    var _a2;
    if (input.value) {
      input.value.value = ((_a2 = modelValue.value) == null ? void 0 : _a2.toString()) ?? "";
    }
  });
  onActivated(() => {
    nextTick(() => {
      if (props.autofocus) {
        focused.value = true;
      }
    });
  });
  const onInput = (evt) => {
    const { value } = evt.target;
    const formattedValue = _formatValue(value, evt);
    if (evt.defaultPrevented) {
      evt.preventDefault();
      return;
    }
    const nextModel = formattedValue;
    updateModelValue(nextModel);
  };
  const onChange = (evt) => {
    const { value } = evt.target;
    const formattedValue = _formatValue(value, evt);
    if (evt.defaultPrevented) {
      evt.preventDefault();
      return;
    }
    const nextModel = formattedValue;
    if (modelValue.value !== nextModel) {
      updateModelValue(formattedValue, true);
    }
  };
  const onBlur = (evt) => {
    if (!modelModifiers.lazy && !props.lazyFormatter && !modelModifiers.trim && debounceNumber.value <= 0)
      return;
    const { value } = evt.target;
    const formattedValue = _formatValue(value, evt, true);
    const nextModel = modelModifiers.trim ? formattedValue.trim() : formattedValue;
    const needsForceUpdate = nextModel.length !== formattedValue.length;
    internalUpdateModelValue.cancel();
    if (modelValue.value !== nextModel) {
      updateModelValue(formattedValue, true, true);
    }
    if (modelModifiers.trim && needsForceUpdate) {
      forceUpdateKey.value = forceUpdateKey.value + 1;
    }
  };
  const focus = () => {
    if (!props.disabled) {
      focused.value = true;
    }
  };
  const blur = () => {
    if (!props.disabled) {
      focused.value = false;
    }
  };
  return {
    input,
    computedId,
    computedAriaInvalid,
    onInput,
    onChange,
    onBlur,
    focus,
    blur,
    forceUpdateKey,
    stateClass
  };
};
export {
  normalizeInput as n,
  useFormInput as u
};
//# sourceMappingURL=useFormInput-Dru3Y8-y.mjs.map
