import { type StyleValue } from 'vue';
import type { ButtonType, ColorVariant } from '../../types';
export declare const computeSize: (value: any) => string | null;
declare const _sfc_main: import("vue").DefineComponent<{
    alt: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    ariaLabel: {
        type: StringConstructor;
        required: false;
    };
    badge: {
        type: (StringConstructor | BooleanConstructor)[];
        required: false;
        default: boolean;
    };
    badgeLeft: {
        type: null;
        required: false;
        default: boolean;
    };
    badgeOffset: {
        type: StringConstructor;
        required: false;
    };
    badgeTop: {
        type: null;
        required: false;
        default: boolean;
    };
    badgeVariant: {
        type: null;
        required: false;
        default: string;
    };
    button: {
        type: null;
        required: false;
        default: boolean;
    };
    buttonType: {
        type: null;
        required: false;
        default: string;
    };
    disabled: {
        type: null;
        required: false;
        default: boolean;
    };
    icon: {
        type: StringConstructor;
        required: false;
    };
    rounded: {
        type: (StringConstructor | BooleanConstructor)[];
        required: false;
        default: string;
    };
    size: {
        type: StringConstructor;
        required: false;
    };
    square: {
        type: null;
        required: false;
        default: boolean;
    };
    src: {
        type: StringConstructor;
        required: false;
    };
    text: {
        type: StringConstructor;
        required: false;
    };
    textVariant: {
        type: null;
        required: false;
    };
    variant: {
        type: null;
        required: false;
        default: string;
    };
}, {
    computeSize: (value: any) => string | null;
    props: any;
    emit: {
        (e: 'click', value: MouseEvent): void;
        (e: 'img-error', value: Event): void;
    };
    slots: Readonly<{
        [name: string]: import("vue").Slot | undefined;
    }>;
    parentData: import("../../types/components").BAvatarGroupParentData | undefined;
    SIZES: (string | null)[];
    FONT_SIZE_SCALE: number;
    BADGE_FONT_SIZE_SCALE: number;
    badgeLeftBoolean: Readonly<import("vue").Ref<boolean>>;
    badgeTopBoolean: Readonly<import("vue").Ref<boolean>>;
    buttonBoolean: Readonly<import("vue").Ref<boolean>>;
    disabledBoolean: Readonly<import("vue").Ref<boolean>>;
    squareBoolean: Readonly<import("vue").Ref<boolean>>;
    hasDefaultSlot: import("vue").ComputedRef<boolean>;
    hasBadgeSlot: import("vue").ComputedRef<boolean>;
    showBadge: import("vue").ComputedRef<boolean>;
    computedSize: import("vue").ComputedRef<string | null>;
    computedVariant: import("vue").ComputedRef<keyof import("../../types").BaseColorVariant>;
    computedRounded: import("vue").ComputedRef<string | boolean>;
    computedAttrs: import("vue").ComputedRef<{
        type: ButtonType | undefined;
        'aria-label': string | null;
        disabled: true | null;
    }>;
    badgeClasses: import("vue").ComputedRef<string[]>;
    badgeText: import("vue").ComputedRef<string | false>;
    badgeTextClasses: import("vue").ComputedRef<string[][]>;
    computedClasses: import("vue").ComputedRef<{
        [x: string]: boolean;
        badge: boolean;
        rounded: boolean;
        "rounded-circle": boolean;
        "rounded-0": boolean;
        "rounded-1": boolean;
        "rounded-3": boolean;
        "rounded-top": boolean;
        "rounded-bottom": boolean;
        "rounded-start": boolean;
        "rounded-end": boolean;
        btn: boolean;
    }>;
    textClasses: import("vue").ComputedRef<string[][]>;
    badgeStyle: import("vue").ComputedRef<StyleValue>;
    textFontStyle: import("vue").ComputedRef<StyleValue>;
    marginStyle: import("vue").ComputedRef<{
        marginLeft: string;
        marginRight: string;
    } | {
        marginLeft?: undefined;
        marginRight?: undefined;
    }>;
    computedTag: import("vue").ComputedRef<"button" | "span">;
    computedStyle: import("vue").ComputedRef<{
        width: string | null;
        height: string | null;
        marginLeft: string;
        marginRight: string;
    } | {
        width: string | null;
        height: string | null;
        marginLeft?: undefined;
        marginRight?: undefined;
    }>;
    computeContrastVariant: (colorVariant: ColorVariant) => 'dark' | 'light';
    clicked: (e: MouseEvent) => void;
    onImgError: (e: Event) => void;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("click" | "img-error")[], "click" | "img-error", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    alt: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    ariaLabel: {
        type: StringConstructor;
        required: false;
    };
    badge: {
        type: (StringConstructor | BooleanConstructor)[];
        required: false;
        default: boolean;
    };
    badgeLeft: {
        type: null;
        required: false;
        default: boolean;
    };
    badgeOffset: {
        type: StringConstructor;
        required: false;
    };
    badgeTop: {
        type: null;
        required: false;
        default: boolean;
    };
    badgeVariant: {
        type: null;
        required: false;
        default: string;
    };
    button: {
        type: null;
        required: false;
        default: boolean;
    };
    buttonType: {
        type: null;
        required: false;
        default: string;
    };
    disabled: {
        type: null;
        required: false;
        default: boolean;
    };
    icon: {
        type: StringConstructor;
        required: false;
    };
    rounded: {
        type: (StringConstructor | BooleanConstructor)[];
        required: false;
        default: string;
    };
    size: {
        type: StringConstructor;
        required: false;
    };
    square: {
        type: null;
        required: false;
        default: boolean;
    };
    src: {
        type: StringConstructor;
        required: false;
    };
    text: {
        type: StringConstructor;
        required: false;
    };
    textVariant: {
        type: null;
        required: false;
    };
    variant: {
        type: null;
        required: false;
        default: string;
    };
}>> & {
    onClick?: ((...args: any[]) => any) | undefined;
    "onImg-error"?: ((...args: any[]) => any) | undefined;
}, {
    variant: any;
    button: any;
    disabled: any;
    alt: string;
    badge: string | boolean;
    badgeLeft: any;
    badgeTop: any;
    badgeVariant: any;
    buttonType: any;
    rounded: string | boolean;
    square: any;
}>;
export default _sfc_main;
