import type { AriaInvalid, Booleanish, ButtonVariant, Size } from '../../types';
interface BFormCheckboxGroupProps {
    id?: string;
    form?: string;
    modelValue?: Array<string | number | Record<string, unknown>>;
    ariaInvalid?: AriaInvalid;
    autofocus?: Booleanish;
    buttonVariant?: ButtonVariant;
    buttons?: Booleanish;
    disabled?: Booleanish;
    disabledField?: string;
    htmlField?: string;
    name?: string;
    options?: Array<string | Record<string, unknown>>;
    plain?: Booleanish;
    required?: Booleanish;
    size?: Size;
    stacked?: Booleanish;
    state?: Booleanish;
    switches?: Booleanish;
    textField?: string;
    validated?: Booleanish;
    valueField?: string;
}
declare const _sfc_main: import("vue").DefineComponent<{
    id: {
        type: StringConstructor;
        required: false;
    };
    form: {
        type: StringConstructor;
        required: false;
    };
    modelValue: {
        type: ArrayConstructor;
        required: false;
        default: () => never[];
    };
    ariaInvalid: {
        type: null;
        required: false;
        default: undefined;
    };
    autofocus: {
        type: null;
        required: false;
        default: boolean;
    };
    buttonVariant: {
        type: null;
        required: false;
        default: string;
    };
    buttons: {
        type: null;
        required: false;
        default: boolean;
    };
    disabled: {
        type: null;
        required: false;
        default: boolean;
    };
    disabledField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    htmlField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    name: {
        type: StringConstructor;
        required: false;
    };
    options: {
        type: ArrayConstructor;
        required: false;
        default: () => never[];
    };
    plain: {
        type: null;
        required: false;
        default: boolean;
    };
    required: {
        type: null;
        required: false;
        default: boolean;
    };
    size: {
        type: null;
        required: false;
    };
    stacked: {
        type: null;
        required: false;
        default: boolean;
    };
    state: {
        type: null;
        required: false;
        default: undefined;
    };
    switches: {
        type: null;
        required: false;
        default: boolean;
    };
    textField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    validated: {
        type: null;
        required: false;
        default: boolean;
    };
    valueField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
}, {
    props: any;
    emit: {
        (e: 'input', value: Exclude<BFormCheckboxGroupProps['modelValue'], undefined>): void;
        (e: 'update:modelValue', value: Exclude<BFormCheckboxGroupProps['modelValue'], undefined>): void;
        (e: 'change', value: Exclude<BFormCheckboxGroupProps['modelValue'], undefined>): void;
    };
    slots: Readonly<{
        [name: string]: import("vue").Slot | undefined;
    }>;
    slotsName: string;
    computedId: import("vue").ComputedRef<string>;
    computedName: import("vue").ComputedRef<string>;
    autofocusBoolean: Readonly<import("vue").Ref<boolean>>;
    buttonsBoolean: Readonly<import("vue").Ref<boolean>>;
    disabledBoolean: Readonly<import("vue").Ref<boolean>>;
    plainBoolean: Readonly<import("vue").Ref<boolean>>;
    requiredBoolean: Readonly<import("vue").Ref<boolean>>;
    stackedBoolean: Readonly<import("vue").Ref<boolean>>;
    stateBoolean: Readonly<import("vue").Ref<boolean>>;
    switchesBoolean: Readonly<import("vue").Ref<boolean>>;
    validatedBoolean: Readonly<import("vue").Ref<boolean>>;
    localValue: import("vue").WritableComputedRef<(string | number | Record<string, unknown>)[]>;
    checkboxList: import("vue").ComputedRef<any[]>;
    classesObject: {
        required: boolean;
        ariaInvalid: AriaInvalid;
        state: boolean;
        validated: boolean;
        buttons: boolean;
        stacked: boolean;
        size: Size;
    };
    computedAttrs: import("vue").ComputedRef<{
        'aria-invalid': boolean | "true" | "false" | "grammar" | "spelling" | undefined;
        'aria-required': boolean | undefined;
    }>;
    computedClasses: import("vue").ComputedRef<{
        [x: string]: boolean;
        'was-validated': boolean;
        'btn-group': boolean;
        'btn-group-vertical': boolean;
    }>;
    BFormCheckbox: import("vue").DefineComponent<{
        ariaLabel: {
            type: StringConstructor;
            required: false;
        };
        ariaLabelledBy: {
            type: StringConstructor;
            required: false;
        };
        form: {
            type: StringConstructor;
            required: false;
        };
        indeterminate: {
            type: null;
            required: false;
        };
        name: {
            type: StringConstructor;
            required: false;
        };
        id: {
            type: StringConstructor;
            required: false;
            default: undefined;
        };
        autofocus: {
            type: null;
            required: false;
            default: boolean;
        };
        plain: {
            type: null;
            required: false;
            default: boolean;
        };
        button: {
            type: null;
            required: false;
            default: boolean;
        };
        switch: {
            type: null;
            required: false;
            default: boolean;
        };
        disabled: {
            type: null;
            required: false;
            default: boolean;
        };
        buttonVariant: {
            type: null;
            required: false;
            default: string;
        };
        inline: {
            type: null;
            required: false;
            default: boolean;
        };
        required: {
            type: null;
            required: false;
            default: undefined;
        };
        size: {
            type: null;
            required: false;
            default: string;
        };
        state: {
            type: null;
            required: false;
            default: undefined;
        };
        uncheckedValue: {
            type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor | ArrayConstructor | SetConstructor)[];
            required: false;
            default: boolean;
        };
        value: {
            type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor | ArrayConstructor | SetConstructor)[];
            required: false;
            default: boolean;
        };
        modelValue: {
            type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor | ArrayConstructor | SetConstructor)[];
            required: false;
            default: undefined;
        };
    }, {
        props: any;
        emit: {
            (e: "update:modelValue", value: unknown): void;
            (e: "input", value: unknown): void;
            (e: "change", value: unknown): void;
        };
        slots: Readonly<{
            [name: string]: import("vue").Slot | undefined;
        }>;
        computedId: import("vue").ComputedRef<string>;
        indeterminateBoolean: Readonly<import("vue").Ref<boolean | undefined>>;
        autofocusBoolean: Readonly<import("vue").Ref<boolean>>;
        plainBoolean: Readonly<import("vue").Ref<boolean>>;
        buttonBoolean: Readonly<import("vue").Ref<boolean>>;
        switchBoolean: Readonly<import("vue").Ref<boolean>>;
        disabledBoolean: Readonly<import("vue").Ref<boolean>>;
        inlineBoolean: Readonly<import("vue").Ref<boolean>>;
        requiredBoolean: Readonly<import("vue").Ref<boolean>>;
        stateBoolean: Readonly<import("vue").Ref<boolean>>;
        input: import("vue").Ref<HTMLElement>;
        isFocused: import("vue").Ref<boolean>;
        hasDefaultSlot: import("vue").ComputedRef<boolean>;
        localValue: import("vue").WritableComputedRef<boolean | unknown[] | Set<unknown> | undefined>;
        isChecked: import("vue").ComputedRef<boolean>;
        classesObject: {
            plain: boolean;
            button: boolean;
            inline: boolean;
            switch: boolean;
            size: keyof import("../../types/InputSize").BaseInputSize;
            state: boolean;
            buttonVariant: keyof import("../../types").BaseButtonVariant;
        };
        computedClasses: import("vue").ComputedRef<{
            [x: string]: boolean;
            'form-check': boolean;
            'form-check-inline': boolean;
            'form-switch': boolean;
        }>;
        inputClasses: import("vue").ComputedRef<{
            'form-check-input': boolean;
            'is-valid': boolean;
            'is-invalid': boolean;
            'btn-check': boolean;
        }>;
        labelClasses: import("vue").ComputedRef<{
            [x: string]: boolean | undefined;
            'form-check-label': boolean;
            btn: boolean;
        }>;
    }, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("update:modelValue" | "input" | "change")[], "update:modelValue" | "input" | "change", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
        ariaLabel: {
            type: StringConstructor;
            required: false;
        };
        ariaLabelledBy: {
            type: StringConstructor;
            required: false;
        };
        form: {
            type: StringConstructor;
            required: false;
        };
        indeterminate: {
            type: null;
            required: false;
        };
        name: {
            type: StringConstructor;
            required: false;
        };
        id: {
            type: StringConstructor;
            required: false;
            default: undefined;
        };
        autofocus: {
            type: null;
            required: false;
            default: boolean;
        };
        plain: {
            type: null;
            required: false;
            default: boolean;
        };
        button: {
            type: null;
            required: false;
            default: boolean;
        };
        switch: {
            type: null;
            required: false;
            default: boolean;
        };
        disabled: {
            type: null;
            required: false;
            default: boolean;
        };
        buttonVariant: {
            type: null;
            required: false;
            default: string;
        };
        inline: {
            type: null;
            required: false;
            default: boolean;
        };
        required: {
            type: null;
            required: false;
            default: undefined;
        };
        size: {
            type: null;
            required: false;
            default: string;
        };
        state: {
            type: null;
            required: false;
            default: undefined;
        };
        uncheckedValue: {
            type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor | ArrayConstructor | SetConstructor)[];
            required: false;
            default: boolean;
        };
        value: {
            type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor | ArrayConstructor | SetConstructor)[];
            required: false;
            default: boolean;
        };
        modelValue: {
            type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor | ArrayConstructor | SetConstructor)[];
            required: false;
            default: undefined;
        };
    }>> & {
        "onUpdate:modelValue"?: ((...args: any[]) => any) | undefined;
        onInput?: ((...args: any[]) => any) | undefined;
        onChange?: ((...args: any[]) => any) | undefined;
    }, {
        id: string;
        required: any;
        value: string | number | boolean | unknown[] | Record<string, any> | Set<unknown>;
        modelValue: string | number | boolean | unknown[] | Record<string, any> | Set<unknown>;
        button: any;
        disabled: any;
        inline: any;
        size: any;
        autofocus: any;
        plain: any;
        switch: any;
        buttonVariant: any;
        state: any;
        uncheckedValue: string | number | boolean | unknown[] | Record<string, any> | Set<unknown>;
    }>;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("update:modelValue" | "input" | "change")[], "update:modelValue" | "input" | "change", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    id: {
        type: StringConstructor;
        required: false;
    };
    form: {
        type: StringConstructor;
        required: false;
    };
    modelValue: {
        type: ArrayConstructor;
        required: false;
        default: () => never[];
    };
    ariaInvalid: {
        type: null;
        required: false;
        default: undefined;
    };
    autofocus: {
        type: null;
        required: false;
        default: boolean;
    };
    buttonVariant: {
        type: null;
        required: false;
        default: string;
    };
    buttons: {
        type: null;
        required: false;
        default: boolean;
    };
    disabled: {
        type: null;
        required: false;
        default: boolean;
    };
    disabledField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    htmlField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    name: {
        type: StringConstructor;
        required: false;
    };
    options: {
        type: ArrayConstructor;
        required: false;
        default: () => never[];
    };
    plain: {
        type: null;
        required: false;
        default: boolean;
    };
    required: {
        type: null;
        required: false;
        default: boolean;
    };
    size: {
        type: null;
        required: false;
    };
    stacked: {
        type: null;
        required: false;
        default: boolean;
    };
    state: {
        type: null;
        required: false;
        default: undefined;
    };
    switches: {
        type: null;
        required: false;
        default: boolean;
    };
    textField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    validated: {
        type: null;
        required: false;
        default: boolean;
    };
    valueField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
}>> & {
    "onUpdate:modelValue"?: ((...args: any[]) => any) | undefined;
    onInput?: ((...args: any[]) => any) | undefined;
    onChange?: ((...args: any[]) => any) | undefined;
}, {
    required: any;
    modelValue: unknown[];
    disabled: any;
    validated: any;
    autofocus: any;
    plain: any;
    buttonVariant: any;
    state: any;
    ariaInvalid: any;
    buttons: any;
    disabledField: string;
    htmlField: string;
    options: unknown[];
    stacked: any;
    switches: any;
    textField: string;
    valueField: string;
}>;
export default _sfc_main;
