import type { AriaInvalid, Booleanish, ButtonVariant, Size } from '../../types';
interface BFormRadioGroupProps {
    size?: Size;
    form?: string;
    id?: string;
    name?: string;
    modelValue?: string | boolean | Array<unknown> | Record<string, unknown> | number;
    ariaInvalid?: AriaInvalid;
    autofocus?: Booleanish;
    buttonVariant?: ButtonVariant;
    buttons?: Booleanish;
    disabled?: Booleanish;
    disabledField?: string;
    htmlField?: string;
    options?: Array<unknown>;
    plain?: Booleanish;
    required?: Booleanish;
    stacked?: Booleanish;
    state?: Booleanish;
    textField?: string;
    validated?: Booleanish;
    valueField?: string;
}
declare const _sfc_main: import("vue").DefineComponent<{
    size: {
        type: null;
        required: false;
    };
    form: {
        type: StringConstructor;
        required: false;
    };
    id: {
        type: StringConstructor;
        required: false;
    };
    name: {
        type: StringConstructor;
        required: false;
    };
    modelValue: {
        type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor | ArrayConstructor)[];
        required: false;
        default: string;
    };
    ariaInvalid: {
        type: null;
        required: false;
        default: undefined;
    };
    autofocus: {
        type: null;
        required: false;
        default: boolean;
    };
    buttonVariant: {
        type: null;
        required: false;
        default: string;
    };
    buttons: {
        type: null;
        required: false;
        default: boolean;
    };
    disabled: {
        type: null;
        required: false;
        default: boolean;
    };
    disabledField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    htmlField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    options: {
        type: ArrayConstructor;
        required: false;
        default: () => never[];
    };
    plain: {
        type: null;
        required: false;
        default: boolean;
    };
    required: {
        type: null;
        required: false;
        default: boolean;
    };
    stacked: {
        type: null;
        required: false;
        default: boolean;
    };
    state: {
        type: null;
        required: false;
        default: undefined;
    };
    textField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    validated: {
        type: null;
        required: false;
        default: boolean;
    };
    valueField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
}, {
    props: any;
    emit: {
        (e: 'input', value: BFormRadioGroupProps['modelValue']): void;
        (e: 'update:modelValue', value: BFormRadioGroupProps['modelValue']): void;
        (e: 'change', value: BFormRadioGroupProps['modelValue']): void;
    };
    slots: Readonly<{
        [name: string]: import("vue").Slot | undefined;
    }>;
    slotsName: string;
    computedId: import("vue").ComputedRef<string>;
    computedName: import("vue").ComputedRef<string>;
    autofocusBoolean: Readonly<import("vue").Ref<boolean>>;
    buttonsBoolean: Readonly<import("vue").Ref<boolean>>;
    disabledBoolean: Readonly<import("vue").Ref<boolean>>;
    plainBoolean: Readonly<import("vue").Ref<boolean>>;
    requiredBoolean: Readonly<import("vue").Ref<boolean>>;
    stackedBoolean: Readonly<import("vue").Ref<boolean>>;
    stateBoolean: Readonly<import("vue").Ref<boolean>>;
    validatedBoolean: Readonly<import("vue").Ref<boolean>>;
    localValue: import("vue").WritableComputedRef<string | number | boolean | unknown[] | Record<string, unknown>>;
    checkboxList: import("vue").ComputedRef<any[]>;
    classesObject: {
        required: boolean;
        ariaInvalid: AriaInvalid;
        state: boolean;
        validated: boolean;
        buttons: boolean;
        stacked: boolean;
        size: Size;
    };
    computedAttrs: import("vue").ComputedRef<{
        'aria-invalid': boolean | "true" | "false" | "grammar" | "spelling" | undefined;
        'aria-required': boolean | undefined;
    }>;
    computedClasses: import("vue").ComputedRef<{
        [x: string]: boolean;
        'was-validated': boolean;
        'btn-group': boolean;
        'btn-group-vertical': boolean;
    }>;
    BFormRadio: import("vue").DefineComponent<{
        ariaLabel: {
            type: StringConstructor;
            required: false;
        };
        ariaLabelledby: {
            type: StringConstructor;
            required: false;
        };
        form: {
            type: StringConstructor;
            required: false;
        };
        id: {
            type: StringConstructor;
            required: false;
        };
        name: {
            type: StringConstructor;
            required: false;
        };
        size: {
            type: null;
            required: false;
        };
        autofocus: {
            type: null;
            required: false;
            default: boolean;
        };
        modelValue: {
            type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor | ArrayConstructor)[];
            required: false;
            default: undefined;
        };
        plain: {
            type: null;
            required: false;
            default: boolean;
        };
        button: {
            type: null;
            required: false;
            default: boolean;
        };
        switch: {
            type: null;
            required: false;
            default: boolean;
        };
        disabled: {
            type: null;
            required: false;
            default: boolean;
        };
        buttonVariant: {
            type: null;
            required: false;
            default: string;
        };
        inline: {
            type: null;
            required: false;
            default: boolean;
        };
        required: {
            type: null;
            required: false;
            default: boolean;
        };
        state: {
            type: null;
            required: false;
            default: undefined;
        };
        value: {
            type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor)[];
            required: false;
            default: boolean;
        };
    }, {
        props: any;
        emit: {
            (e: "input", value: string | number | boolean | unknown[] | Record<string, unknown>): void;
            (e: "change", value: string | number | boolean | unknown[] | Record<string, unknown>): void;
            (e: "update:modelValue", value: string | number | boolean | unknown[] | Record<string, unknown>): void;
        };
        slots: Readonly<{
            [name: string]: import("vue").Slot | undefined;
        }>;
        computedId: import("vue").ComputedRef<string>;
        autofocusBoolean: Readonly<import("vue").Ref<boolean>>;
        plainBoolean: Readonly<import("vue").Ref<boolean>>;
        buttonBoolean: Readonly<import("vue").Ref<boolean>>;
        switchBoolean: Readonly<import("vue").Ref<boolean>>;
        disabledBoolean: Readonly<import("vue").Ref<boolean>>;
        inlineBoolean: Readonly<import("vue").Ref<boolean>>;
        requiredBoolean: Readonly<import("vue").Ref<boolean>>;
        stateBoolean: Readonly<import("vue").Ref<boolean>>;
        input: import("vue").Ref<HTMLElement | null>;
        isFocused: import("vue").Ref<boolean>;
        localValue: import("vue").WritableComputedRef<unknown>;
        isChecked: import("vue").ComputedRef<unknown>;
        hasDefaultSlot: import("vue").ComputedRef<boolean>;
        classesObject: {
            plain: boolean;
            button: boolean;
            inline: boolean;
            switch: boolean;
            size: keyof import("../../types/InputSize").BaseInputSize | undefined;
            state: boolean;
            buttonVariant: keyof import("../../types").BaseButtonVariant;
        };
        computedClasses: import("vue").ComputedRef<{
            [x: string]: boolean;
            'form-check': boolean;
            'form-check-inline': boolean;
            'form-switch': boolean;
        }>;
        inputClasses: import("vue").ComputedRef<{
            'form-check-input': boolean;
            'is-valid': boolean;
            'is-invalid': boolean;
            'btn-check': boolean;
        }>;
        labelClasses: import("vue").ComputedRef<{
            [x: string]: boolean | undefined;
            'form-check-label': boolean;
            btn: boolean;
        }>;
    }, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("update:modelValue" | "input" | "change")[], "update:modelValue" | "input" | "change", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
        ariaLabel: {
            type: StringConstructor;
            required: false;
        };
        ariaLabelledby: {
            type: StringConstructor;
            required: false;
        };
        form: {
            type: StringConstructor;
            required: false;
        };
        id: {
            type: StringConstructor;
            required: false;
        };
        name: {
            type: StringConstructor;
            required: false;
        };
        size: {
            type: null;
            required: false;
        };
        autofocus: {
            type: null;
            required: false;
            default: boolean;
        };
        modelValue: {
            type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor | ArrayConstructor)[];
            required: false;
            default: undefined;
        };
        plain: {
            type: null;
            required: false;
            default: boolean;
        };
        button: {
            type: null;
            required: false;
            default: boolean;
        };
        switch: {
            type: null;
            required: false;
            default: boolean;
        };
        disabled: {
            type: null;
            required: false;
            default: boolean;
        };
        buttonVariant: {
            type: null;
            required: false;
            default: string;
        };
        inline: {
            type: null;
            required: false;
            default: boolean;
        };
        required: {
            type: null;
            required: false;
            default: boolean;
        };
        state: {
            type: null;
            required: false;
            default: undefined;
        };
        value: {
            type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor)[];
            required: false;
            default: boolean;
        };
    }>> & {
        "onUpdate:modelValue"?: ((...args: any[]) => any) | undefined;
        onInput?: ((...args: any[]) => any) | undefined;
        onChange?: ((...args: any[]) => any) | undefined;
    }, {
        required: any;
        value: string | number | boolean | Record<string, any>;
        modelValue: string | number | boolean | unknown[] | Record<string, any>;
        button: any;
        disabled: any;
        inline: any;
        autofocus: any;
        plain: any;
        switch: any;
        buttonVariant: any;
        state: any;
    }>;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("update:modelValue" | "input" | "change")[], "update:modelValue" | "input" | "change", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    size: {
        type: null;
        required: false;
    };
    form: {
        type: StringConstructor;
        required: false;
    };
    id: {
        type: StringConstructor;
        required: false;
    };
    name: {
        type: StringConstructor;
        required: false;
    };
    modelValue: {
        type: (StringConstructor | BooleanConstructor | ObjectConstructor | NumberConstructor | ArrayConstructor)[];
        required: false;
        default: string;
    };
    ariaInvalid: {
        type: null;
        required: false;
        default: undefined;
    };
    autofocus: {
        type: null;
        required: false;
        default: boolean;
    };
    buttonVariant: {
        type: null;
        required: false;
        default: string;
    };
    buttons: {
        type: null;
        required: false;
        default: boolean;
    };
    disabled: {
        type: null;
        required: false;
        default: boolean;
    };
    disabledField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    htmlField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    options: {
        type: ArrayConstructor;
        required: false;
        default: () => never[];
    };
    plain: {
        type: null;
        required: false;
        default: boolean;
    };
    required: {
        type: null;
        required: false;
        default: boolean;
    };
    stacked: {
        type: null;
        required: false;
        default: boolean;
    };
    state: {
        type: null;
        required: false;
        default: undefined;
    };
    textField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
    validated: {
        type: null;
        required: false;
        default: boolean;
    };
    valueField: {
        type: StringConstructor;
        required: false;
        default: string;
    };
}>> & {
    "onUpdate:modelValue"?: ((...args: any[]) => any) | undefined;
    onInput?: ((...args: any[]) => any) | undefined;
    onChange?: ((...args: any[]) => any) | undefined;
}, {
    required: any;
    modelValue: string | number | boolean | unknown[] | Record<string, any>;
    disabled: any;
    validated: any;
    autofocus: any;
    plain: any;
    buttonVariant: any;
    state: any;
    ariaInvalid: any;
    buttons: any;
    disabledField: string;
    htmlField: string;
    options: unknown[];
    stacked: any;
    textField: string;
    valueField: string;
}>;
export default _sfc_main;
