import type { AriaInvalid, ButtonVariant, InputSize } from '../types';
import { type ComputedRef } from 'vue';
/**
 * @param items must be a reactive object ex: reactive({ plain: toRef(plainBoolean, 'value')})
 * @returns
 */
declare const getClasses: (items: {
    plain?: boolean;
    button?: boolean;
    inline?: boolean;
    switch?: boolean;
    size?: InputSize;
}) => ComputedRef<{
    [x: string]: boolean;
    'form-check': boolean;
    'form-check-inline': boolean;
    'form-switch': boolean;
}>;
/**
 * @param items must be a reactive object ex: reactive({ plain: toRef(plainBoolean, 'value')})
 * @returns
 */
declare const getInputClasses: (items: {
    plain?: boolean;
    button?: boolean;
    state?: boolean;
}) => ComputedRef<{
    'form-check-input': boolean;
    'is-valid': boolean;
    'is-invalid': boolean;
    'btn-check': boolean;
}>;
/**
 * @param items must be a reactive object ex: reactive({ plain: toRef(plainBoolean, 'value')})
 * @returns
 */
declare const getLabelClasses: (items: {
    plain?: boolean;
    button?: boolean;
    buttonVariant?: ButtonVariant;
    size?: InputSize;
}) => ComputedRef<{
    [x: string]: boolean | undefined;
    'form-check-label': boolean;
    btn: boolean;
}>;
/**
 * @param items must be a reactive object ex: reactive({ plain: toRef(plainBoolean, 'value')})
 * @returns
 */
declare const getGroupAttr: (items: {
    required?: boolean;
    ariaInvalid?: AriaInvalid;
    state?: boolean;
}) => ComputedRef<{
    'aria-invalid': boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-required': boolean | undefined;
}>;
/**
 * @param items must be a reactive object ex: reactive({ plain: toRef(plainBoolean, 'value')})
 * @returns
 */
declare const getGroupClasses: (items: {
    validated?: boolean;
    buttons?: boolean;
    stacked?: boolean;
    size?: InputSize;
}) => ComputedRef<{
    [x: string]: boolean;
    'was-validated': boolean;
    'btn-group': boolean;
    'btn-group-vertical': boolean;
}>;
/**
 * @param slots
 * @param nodeType
 * @param disabled
 * @returns
 */
declare const slotsToElements: (slots: Array<any>, nodeType: string, disabled: boolean) => {
    props: any;
    text: any;
}[];
/**
 * @param option
 * @param props
 * @returns
 */
declare const optionToElement: (option: any, props: any) => any;
/**
 * @param el
 * @param idx
 * @param props
 * @param computedName
 * @param computedId
 * @returns
 */
declare const bindGroupProps: (el: any, idx: number, props: any, computedName: ComputedRef<string>, computedId: ComputedRef<string>) => any;
export { getClasses, getInputClasses, getLabelClasses, getGroupAttr, getGroupClasses, slotsToElements, optionToElement, bindGroupProps, };
