/**
 * SSR safe types
 */
export declare const WINDOW: {};
export declare const DOCUMENT: {};
export declare type AnimationFrame = typeof requestAnimationFrame;
declare global {
    interface Window {
        requestAnimationFrame: AnimationFrame;
        webkitRequestAnimationFrame: AnimationFrame;
        mozRequestAnimationFrame: AnimationFrame;
        msRequestAnimationFrame: AnimationFrame;
        oRequestAnimationFrame: AnimationFrame;
    }
}
export declare const Element: {
    new (): Element;
    prototype: Element;
} | {
    new (value?: any): {
        constructor: Function;
        toString(): string;
        toLocaleString(): string;
        valueOf(): Object;
        hasOwnProperty(v: PropertyKey): boolean;
        isPrototypeOf(v: Object): boolean;
        propertyIsEnumerable(v: PropertyKey): boolean;
        should: Chai.Assertion;
    };
    getPrototypeOf(o: any): any;
    getOwnPropertyDescriptor(o: any, p: PropertyKey): PropertyDescriptor | undefined;
    getOwnPropertyNames(o: any): string[];
    create(o: object | null): any;
    create(o: object | null, properties: PropertyDescriptorMap & ThisType<any>): any;
    defineProperty<T>(o: T, p: PropertyKey, attributes: PropertyDescriptor & ThisType<any>): T;
    defineProperties<T_1>(o: T_1, properties: PropertyDescriptorMap & ThisType<any>): T_1;
    seal<T_2>(o: T_2): T_2;
    freeze<T_3>(a: T_3[]): readonly T_3[];
    freeze<T_4 extends Function>(f: T_4): T_4;
    freeze<T_5 extends {
        [idx: string]: object | U | null | undefined;
    }, U extends string | number | bigint | boolean | symbol>(o: T_5): Readonly<T_5>;
    freeze<T_6>(o: T_6): Readonly<T_6>;
    preventExtensions<T_7>(o: T_7): T_7;
    isSealed(o: any): boolean;
    isFrozen(o: any): boolean;
    isExtensible(o: any): boolean;
    keys(o: object): string[];
    keys(o: {}): string[];
    assign<T_8 extends {}, U_1>(target: T_8, source: U_1): T_8 & U_1;
    assign<T_9 extends {}, U_2, V>(target: T_9, source1: U_2, source2: V): T_9 & U_2 & V;
    assign<T_10 extends {}, U_3, V_1, W>(target: T_10, source1: U_3, source2: V_1, source3: W): T_10 & U_3 & V_1 & W;
    assign(target: object, ...sources: any[]): any;
    getOwnPropertySymbols(o: any): symbol[];
    is(value1: any, value2: any): boolean;
    setPrototypeOf(o: any, proto: object | null): any;
    values<T_11>(o: {
        [s: string]: T_11;
    } | ArrayLike<T_11>): T_11[];
    values(o: {}): any[];
    entries<T_12>(o: {
        [s: string]: T_12;
    } | ArrayLike<T_12>): [string, T_12][];
    entries(o: {}): [string, any][];
    getOwnPropertyDescriptors<T_13>(o: T_13): { [P in keyof T_13]: TypedPropertyDescriptor<T_13[P]>; } & {
        [x: string]: PropertyDescriptor;
    };
    fromEntries<T_14 = any>(entries: Iterable<readonly [PropertyKey, T_14]>): {
        [k: string]: T_14;
    };
    fromEntries(entries: Iterable<readonly any[]>): any;
    hasOwn(o: object, v: PropertyKey): boolean;
};
export declare const HTMLElement: {
    new (): {};
    new (value?: any): {};
};
export declare const SVGElement: {
    new (): {};
    new (value?: any): {};
};
export declare const File: {
    new (fileBits: BlobPart[], fileName: string, options?: FilePropertyBag | undefined): File;
    prototype: File;
} | {
    new (value?: any): {
        constructor: Function;
        toString(): string;
        toLocaleString(): string;
        valueOf(): Object;
        hasOwnProperty(v: PropertyKey): boolean;
        isPrototypeOf(v: Object): boolean;
        propertyIsEnumerable(v: PropertyKey): boolean;
        should: Chai.Assertion;
    };
    getPrototypeOf(o: any): any;
    getOwnPropertyDescriptor(o: any, p: PropertyKey): PropertyDescriptor | undefined;
    getOwnPropertyNames(o: any): string[];
    create(o: object | null): any;
    create(o: object | null, properties: PropertyDescriptorMap & ThisType<any>): any;
    defineProperty<T>(o: T, p: PropertyKey, attributes: PropertyDescriptor & ThisType<any>): T;
    defineProperties<T_1>(o: T_1, properties: PropertyDescriptorMap & ThisType<any>): T_1;
    seal<T_2>(o: T_2): T_2;
    freeze<T_3>(a: T_3[]): readonly T_3[];
    freeze<T_4 extends Function>(f: T_4): T_4;
    freeze<T_5 extends {
        [idx: string]: object | U | null | undefined;
    }, U extends string | number | bigint | boolean | symbol>(o: T_5): Readonly<T_5>;
    freeze<T_6>(o: T_6): Readonly<T_6>;
    preventExtensions<T_7>(o: T_7): T_7;
    isSealed(o: any): boolean;
    isFrozen(o: any): boolean;
    isExtensible(o: any): boolean;
    keys(o: object): string[];
    keys(o: {}): string[];
    assign<T_8 extends {}, U_1>(target: T_8, source: U_1): T_8 & U_1;
    assign<T_9 extends {}, U_2, V>(target: T_9, source1: U_2, source2: V): T_9 & U_2 & V;
    assign<T_10 extends {}, U_3, V_1, W>(target: T_10, source1: U_3, source2: V_1, source3: W): T_10 & U_3 & V_1 & W;
    assign(target: object, ...sources: any[]): any;
    getOwnPropertySymbols(o: any): symbol[];
    is(value1: any, value2: any): boolean;
    setPrototypeOf(o: any, proto: object | null): any;
    values<T_11>(o: {
        [s: string]: T_11;
    } | ArrayLike<T_11>): T_11[];
    values(o: {}): any[];
    entries<T_12>(o: {
        [s: string]: T_12;
    } | ArrayLike<T_12>): [string, T_12][];
    entries(o: {}): [string, any][];
    getOwnPropertyDescriptors<T_13>(o: T_13): { [P in keyof T_13]: TypedPropertyDescriptor<T_13[P]>; } & {
        [x: string]: PropertyDescriptor;
    };
    fromEntries<T_14 = any>(entries: Iterable<readonly [PropertyKey, T_14]>): {
        [k: string]: T_14;
    };
    fromEntries(entries: Iterable<readonly any[]>): any;
    hasOwn(o: object, v: PropertyKey): boolean;
};
