import type { Slot } from 'vue';
import type { AnimationFrame } from '../types/safeTypes';
export declare const matchesEl: any;
/**
 * @param el
 * @returns
 */
export declare const isElement: (el: HTMLElement | Element) => boolean;
/**
 * @param el
 * @returns
 */
export declare const getBCR: (el: HTMLElement) => DOMRect | null;
/**
 * @param excludes
 * @returns
 */
export declare const getActiveElement: (excludes?: never[]) => Element | null;
/**
 * @param el
 * @returns
 */
export declare const isActiveElement: (el: HTMLElement) => boolean;
/**
 * @param el
 * @param options
 * @returns
 */
export declare const attemptFocus: (el: HTMLElement, options?: {}) => boolean;
/**
 * Attempt to blur an element, and return `true` if successful
 *
 * @param el
 * @returns
 */
export declare const attemptBlur: (el: HTMLElement) => boolean;
/**
 * @param el
 * @param prop
 * @returns
 */
export declare const getStyle: (el: HTMLElement, prop: string) => string | null;
/**
 * @param parent
 * @param child
 * @returns
 */
export declare const contains: (parent: Node, child: Node) => boolean;
/**
 * @param el
 * @returns
 */
export declare const isVisible: (el: HTMLElement) => boolean;
/**
 * @param el
 * @returns
 */
export declare const offset: (el: HTMLElement) => {
    top: number;
    left: number;
};
export declare const isEmptySlot: (el: Slot | undefined) => boolean;
/**
 * Select a single element, returns `null` if not found
 *
 * @param selector
 * @param root
 * @returns
 */
export declare const select: (selector: any, root: any) => any;
/**
 * @param selector
 * @param root
 * @returns
 */
export declare const selectAll: (selector: any, root: any) => any[];
/**
 * @param el
 * @param attr
 * @returns
 */
export declare const getAttr: (el: HTMLElement | Element, attr: string) => string | null;
export declare const getById: (id: string) => any;
/**
 * @param el
 * @param attr
 * @param value
 */
export declare const setAttr: (el: HTMLElement, attr: string, value: string) => void;
/**
 * Remove an attribute from an element
 *
 * @param el
 * @param attr
 */
export declare const removeAttr: (el: HTMLElement, attr: string) => void;
/**
 * @param tag
 * @param name
 * @returns
 */
export declare const isTag: (tag: any, name: any) => boolean;
export declare const requestAF: AnimationFrame;
export declare const matches: (el: Element, selector: string) => any;
export declare const closestEl: {
    <K extends keyof HTMLElementTagNameMap>(selector: K): HTMLElementTagNameMap[K] | null;
    <K_1 extends keyof SVGElementTagNameMap>(selector: K_1): SVGElementTagNameMap[K_1] | null;
    <E extends Element = Element>(selectors: string): E | null;
};
export declare const closest: (selector: string, root: Element, includeRoot?: boolean) => Element | null;
