import { mergeData } from '../../utils'

export const props = {
  id: {
    type: String,
    default: null
  },
  tag: {
    type: String,
    default: 'div'
  },
  forceShow: {
    type: Boolean,
    default: false
  }
}

export default {
  functional: true,
  props,
  render (h, { props, data, children }) {
    return h(
      props.tag,
      mergeData(data, {
        staticClass: 'valid-feedback',
        class: { 'd-block': props.forceShow },
        attrs: { id: props.id }
      }),
      children
    )
  }
}
