import { mergeData } from 'vue-functional-data-merge';

export var props = {
  id: {
    type: String,
    default: null
  },
  tag: {
    type: String,
    default: 'div'
  },
  forceShow: {
    type: Boolean,
    default: false
  }
};

export default {
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;

    return h(props.tag, mergeData(data, {
      staticClass: 'invalid-feedback',
      class: { 'd-block': props.forceShow },
      attrs: { id: props.id }
    }), children);
  }
};