"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _id = _interopRequireDefault(require("../../mixins/id"));

var _formRadioCheck = _interopRequireDefault(require("../../mixins/form-radio-check"));

var _form = _interopRequireDefault(require("../../mixins/form"));

var _formSize = _interopRequireDefault(require("../../mixins/form-size"));

var _formState = _interopRequireDefault(require("../../mixins/form-state"));

var _array = require("../../utils/array");

var _looseEqual = _interopRequireDefault(require("../../utils/loose-equal"));

var _looseIndexOf = _interopRequireDefault(require("../../utils/loose-index-of"));

// @vue/component
var _default2 = {
  name: 'BFormCheckbox',
  mixins: [_formRadioCheck.default, // includes shared render function
  _id.default, _form.default, _formSize.default, _formState.default],
  inject: {
    bvGroup: {
      from: 'bvCheckGroup',
      default: function _default() {
        return this;
      }
    }
  },
  props: {
    value: {
      // type: [Object, Boolean],
      default: true
    },
    uncheckedValue: {
      // type: [Object, Boolean],
      // Not applicable in multi-check mode
      default: false
    },
    indeterminate: {
      // Not applicable in multi-check mode
      type: Boolean,
      default: false
    },
    switch: {
      // Custom switch styling
      type: Boolean,
      default: false
    },
    checked: {
      // v-model
      type: [String, Number, Object, Array, Boolean],
      default: null
    }
  },
  computed: {
    is_Checked: function is_Checked() {
      var checked = this.computedLocalChecked;
      var value = this.value;

      if ((0, _array.isArray)(checked)) {
        return (0, _looseIndexOf.default)(checked, value) > -1;
      } else {
        return (0, _looseEqual.default)(checked, value);
      }
    },
    is_Radio: function is_Radio() {
      return false;
    },
    is_Check: function is_Check() {
      return true;
    }
  },
  watch: {
    computedLocalChecked: function computedLocalChecked(newVal, oldVal) {
      this.$emit('input', newVal);

      if (this.$refs && this.$refs.input) {
        this.$emit('update:indeterminate', this.$refs.input.indeterminate);
      }
    },
    indeterminate: function indeterminate(newVal, oldVal) {
      this.setIndeterminate(newVal);
    }
  },
  mounted: function mounted() {
    // Set initial indeterminate state
    this.setIndeterminate(this.indeterminate);
  },
  methods: {
    handleChange: function handleChange(_ref) {
      var _ref$target = _ref.target,
          checked = _ref$target.checked,
          indeterminate = _ref$target.indeterminate;
      var localChecked = this.computedLocalChecked;
      var value = this.value;
      var isArr = (0, _array.isArray)(localChecked);
      var uncheckedValue = isArr ? null : this.uncheckedValue; // Update computedLocalChecked

      if (isArr) {
        var idx = (0, _looseIndexOf.default)(localChecked, value);

        if (checked && idx < 0) {
          // add value to array
          localChecked = localChecked.concat(value);
        } else if (!checked && idx > -1) {
          // remove value from array
          localChecked = localChecked.slice(0, idx).concat(localChecked.slice(idx + 1));
        }
      } else {
        localChecked = checked ? value : uncheckedValue;
      }

      this.computedLocalChecked = localChecked; // Change is only emitted on user interaction

      this.$emit('change', checked ? value : uncheckedValue); // If this is a child of form-checkbox-group, we emit a change event on it as well

      if (this.is_Group) {
        this.bvGroup.$emit('change', localChecked);
      }

      this.$emit('update:indeterminate', indeterminate);
    },
    setIndeterminate: function setIndeterminate(state) {
      // Indeterminate only supported in single checkbox mode
      if ((0, _array.isArray)(this.computedLocalChecked)) {
        state = false;
      }

      if (this.$refs && this.$refs.input) {
        this.$refs.input.indeterminate = state; // Emit update event to prop

        this.$emit('update:indeterminate', state);
      }
    }
  }
};
exports.default = _default2;