"use strict";

exports.__esModule = true;
exports.default = void 0;

var _vue = _interopRequireDefault(require("vue"));

var _vueFunctionalDataMerge = require("vue-functional-data-merge");

var _config = require("../../utils/config");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var NAME = 'BButtonClose';
var props = {
  disabled: {
    type: Boolean,
    default: false
  },
  ariaLabel: {
    type: String,
    default: function _default() {
      return String((0, _config.getComponentConfig)(NAME, 'ariaLabel'));
    }
  },
  textVariant: {
    type: String,
    default: function _default() {
      return String((0, _config.getComponentConfig)(NAME, 'textVariant') || '') || null;
    }
  } // @vue/component

};

var _default2 = _vue.default.extend({
  name: NAME,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        listeners = _ref.listeners,
        slots = _ref.slots;
    var componentData = {
      staticClass: 'close',
      class: _defineProperty({}, "text-".concat(props.textVariant), props.textVariant),
      attrs: {
        type: 'button',
        disabled: props.disabled,
        'aria-label': props.ariaLabel ? String(props.ariaLabel) : null
      },
      on: {
        click: function click(e) {
          // Ensure click on button HTML content is also disabled

          /* istanbul ignore if: bug in JSDOM still emits click on inner element */
          if (props.disabled && e instanceof Event) {
            e.stopPropagation();
            e.preventDefault();
          }
        }
      } // Careful not to override the default slot with innerHTML

    };

    if (!slots().default) {
      componentData.domProps = {
        innerHTML: '&times;'
      };
    }

    return h('button', (0, _vueFunctionalDataMerge.mergeData)(data, componentData), slots().default);
  }
});

exports.default = _default2;