"use strict";

exports.__esModule = true;
exports.default = void 0;

var _vue = _interopRequireDefault(require("vue"));

var _listenOnRoot = _interopRequireDefault(require("../../mixins/listen-on-root"));

var _config = require("../../utils/config");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var NAME = 'BNavbarToggle'; // Events we emit on $root

var EVENT_TOGGLE = 'bv::toggle::collapse'; // Events we listen to on $root

var EVENT_STATE = 'bv::collapse::state'; // This private event is NOT to be documented as people should not be using it.

var EVENT_STATE_SYNC = 'bv::collapse::sync::state'; // @vue/component

var _default2 = _vue.default.extend({
  name: NAME,
  mixins: [_listenOnRoot.default],
  props: {
    label: {
      type: String,
      default: function _default() {
        return String((0, _config.getComponentConfig)(NAME, 'label') || '');
      }
    },
    target: {
      type: String,
      required: true
    }
  },
  data: function data() {
    return {
      toggleState: false
    };
  },
  created: function created() {
    this.listenOnRoot(EVENT_STATE, this.handleStateEvt);
    this.listenOnRoot(EVENT_STATE_SYNC, this.handleStateEvt);
  },
  methods: {
    onClick: function onClick(evt) {
      this.$emit('click', evt);

      if (!evt.defaultPrevented) {
        this.$root.$emit(EVENT_TOGGLE, this.target);
      }
    },
    handleStateEvt: function handleStateEvt(id, state) {
      if (id === this.target) {
        this.toggleState = state;
      }
    }
  },
  render: function render(h) {
    return h('button', {
      class: ['navbar-toggler'],
      attrs: {
        type: 'button',
        'aria-label': this.label,
        'aria-controls': this.target,
        'aria-expanded': this.toggleState ? 'true' : 'false'
      },
      on: {
        click: this.onClick
      }
    }, [this.$slots.default || h('span', {
      class: ['navbar-toggler-icon']
    })]);
  }
});

exports.default = _default2;