"use strict";

exports.__esModule = true;
exports.default = exports.props = void 0;

var _vue = _interopRequireDefault(require("../../utils/vue"));

var _html = require("../../utils/html");

var _config = require("../../utils/config");

var _id = _interopRequireDefault(require("../../mixins/id"));

var _dropdown = _interopRequireDefault(require("../../mixins/dropdown"));

var _button = _interopRequireDefault(require("../button/button"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var NAME = 'BDropdown';
var props = {
  toggleText: {
    // This really should be toggleLabel
    type: String,
    default: function _default() {
      return String((0, _config.getComponentConfig)(NAME, 'toggleText'));
    }
  },
  size: {
    type: String,
    default: null
  },
  variant: {
    type: String,
    default: function _default() {
      return String((0, _config.getComponentConfig)(NAME, 'variant') || '') || null;
    }
  },
  menuClass: {
    type: [String, Array],
    default: null
  },
  toggleTag: {
    type: String,
    default: 'button'
  },
  toggleClass: {
    type: [String, Array],
    default: null
  },
  noCaret: {
    type: Boolean,
    default: false
  },
  split: {
    type: Boolean,
    default: false
  },
  splitHref: {
    type: String // default: undefined

  },
  splitTo: {
    type: [String, Object] // default: undefined

  },
  splitVariant: {
    type: String,
    default: null
  },
  role: {
    type: String,
    default: 'menu'
  },
  boundary: {
    // String: `scrollParent`, `window` or `viewport`
    // Object: HTML Element reference
    type: [String, Object],
    default: 'scrollParent'
  } // @vue/component

};
exports.props = props;

var _default2 = _vue.default.extend({
  name: NAME,
  mixins: [_id.default, _dropdown.default],
  props: props,
  computed: {
    dropdownClasses: function dropdownClasses() {
      // Position `static` is needed to allow menu to "breakout" of the scrollParent boundaries
      // when boundary is anything other than `scrollParent`
      // See https://github.com/twbs/bootstrap/issues/24251#issuecomment-341413786
      var positionStatic = this.boundary !== 'scrollParent' || !this.boundary;
      return ['btn-group', 'b-dropdown', 'dropdown', this.directionClass, {
        show: this.visible,
        'position-static': positionStatic
      }];
    },
    menuClasses: function menuClasses() {
      return ['dropdown-menu', {
        'dropdown-menu-right': this.right,
        show: this.visible
      }, this.menuClass];
    },
    toggleClasses: function toggleClasses() {
      return ['dropdown-toggle', {
        'dropdown-toggle-split': this.split,
        'dropdown-toggle-no-caret': this.noCaret && !this.split
      }, this.toggleClass];
    }
  },
  render: function render(h) {
    var split = h(false);

    if (this.split) {
      var btnProps = {
        disabled: this.disabled,
        variant: this.splitVariant || this.variant,
        size: this.size // We add these as needed due to router-link issues with defined property with undefined/null values

      };

      if (this.splitTo) {
        btnProps.to = this.splitTo;
      }

      if (this.splitHref) {
        btnProps.href = this.splitHref;
      }

      split = h(_button.default, {
        ref: 'button',
        props: btnProps,
        attrs: {
          id: this.safeId('_BV_button_')
        },
        on: {
          click: this.click
        }
      }, [this.$slots['button-content'] || this.$slots.text || this.html || (0, _html.stripTags)(this.text)]);
    }

    var toggle = h(_button.default, {
      ref: 'toggle',
      class: this.toggleClasses,
      props: {
        variant: this.variant,
        size: this.size,
        disabled: this.disabled,
        tag: this.toggleTag
      },
      attrs: {
        id: this.safeId('_BV_toggle_'),
        'aria-haspopup': 'true',
        'aria-expanded': this.visible ? 'true' : 'false'
      },
      on: {
        click: this.toggle,
        // click
        keydown: this.toggle // enter, space, down

      }
    }, [this.split ? h('span', {
      class: ['sr-only']
    }, [this.toggleText]) : this.$slots['button-content'] || this.$slots.text || this.html || (0, _html.stripTags)(this.text)]);
    var menu = h('ul', {
      ref: 'menu',
      class: this.menuClasses,
      attrs: {
        role: this.role,
        tabindex: '-1',
        'aria-labelledby': this.safeId(this.split ? '_BV_button_' : '_BV_toggle_')
      },
      on: {
        mouseover: this.onMouseOver,
        keydown: this.onKeydown // tab, up, down, esc

      }
    }, [this.$slots.default]);
    return h('div', {
      attrs: {
        id: this.safeId()
      },
      class: this.dropdownClasses
    }, [split, toggle, menu]);
  }
});

exports.default = _default2;