"use strict";

exports.__esModule = true;
exports.default = void 0;

var _toast = _interopRequireDefault(require("./toast"));

var _toaster = _interopRequireDefault(require("./toaster"));

var _bvToast = _interopRequireDefault(require("./helpers/bv-toast"));

var _plugins = require("../../utils/plugins");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var components = {
  BToast: _toast.default,
  BToaster: _toaster.default
};

var _install = (0, _plugins.installFactory)({
  components: components
});

var _default = {
  install: function install(Vue) {
    // Inject `$bvToast` into Vue prototype
    (0, _bvToast.default)(Vue); // Install components

    _install(Vue);
  }
};
exports.default = _default;