"use strict";

exports.__esModule = true;
exports.default = exports.modalTargetName = void 0;

var _vue = _interopRequireDefault(require("../../../utils/vue"));

var _portalVue = require("portal-vue");

var _dom = require("../../../utils/dom");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var NAME = 'BModalTarget';
var modalTargetName = "BV-".concat(NAME); // Pivate internal component used by ModalManager.
// Not to be used directly by humans.
// @vue/component

exports.modalTargetName = modalTargetName;

var _default = _vue.default.extend({
  name: NAME,
  data: function data() {
    return {
      doRender: false
    };
  },
  destroyed: function destroyed()
  /* istanbul ignore next */
  {
    // Ensure we get removed from DOM when destroyed
    if (this.$el && this.$el.parentNode) {
      this.$el.parentNode.removeChild(this.$el);
    }
  },
  beforeMount: function beforeMount() {
    var self = this; // There can be only one modal target in the document

    /* istanbul ignore if */

    if (_portalVue.Wormhole.hasTarget(modalTargetName)) {
      this.$once('hook:mounted', function () {
        self.$nextTick(function () {
          (0, _dom.requestAF)(function () {
            self.$destroy();
          });
        });
      });
    } else {
      this.doRender = true;
    }
  },
  render: function render(h) {
    /* istanbul ignore else */
    if (this.doRender) {
      return h(_portalVue.PortalTarget, {
        staticClass: 'b-modal-target',
        props: {
          tag: 'div',
          name: modalTargetName,
          multiple: true,
          transition: null,
          slim: false
        }
      });
    } else {
      return h('div');
    }
  }
});

exports.default = _default;