/*!
 * BoostrapVue 2.0.0-rc.20
 *
 * @link https://bootstrap-vue.js.org
 * @source https://github.com/bootstrap-vue/bootstrap-vue
 * @copyright (c) 2016-2019 BootstrapVue
 * @license MIT
 * https://github.com/bootstrap-vue/bootstrap-vue/blob/master/LICENSE
 */
"use strict";

exports.__esModule = true;
exports.default = void 0;

var _components = _interopRequireDefault(require("./components"));

var _directives = _interopRequireDefault(require("./directives"));

var _plugins = require("./utils/plugins");

var _config = require("./utils/config");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var install = function install(Vue) {
  var config = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  if (install.installed) {
    /* istanbul ignore next */
    return;
  }

  install.installed = true; // Configure BootstrapVue

  (0, _config.setConfig)(config); // Install all component plugins

  Vue.use(_components.default); // Install all directive plugins

  Vue.use(_directives.default);
};

install.installed = false;
var BootstrapVue = {
  install: install,
  setConfig: _config.setConfig // Auto installation only occurs if window.Vue exists

};
(0, _plugins.vueUse)(BootstrapVue);
var _default = BootstrapVue;
exports.default = _default;