"use strict";

exports.__esModule = true;
exports.default = exports.BFormRadioGroup = exports.props = void 0;

var _vue = _interopRequireDefault(require("../../utils/vue"));

var _id = _interopRequireDefault(require("../../mixins/id"));

var _form = _interopRequireDefault(require("../../mixins/form"));

var _formOptions = _interopRequireDefault(require("../../mixins/form-options"));

var _formRadioCheckGroup = _interopRequireDefault(require("../../mixins/form-radio-check-group"));

var _formSize = _interopRequireDefault(require("../../mixins/form-size"));

var _formState = _interopRequireDefault(require("../../mixins/form-state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var props = {
  checked: {
    type: [String, Object, Number, Boolean],
    default: null
  } // @vue/component

};
exports.props = props;

var BFormRadioGroup =
/*#__PURE__*/
_vue.default.extend({
  name: 'BFormRadioGroup',
  mixins: [_id.default, _form.default, _formRadioCheckGroup.default, // Includes render function
  _formOptions.default, _formSize.default, _formState.default],
  provide: function provide() {
    return {
      bvRadioGroup: this
    };
  },
  props: props,
  data: function data() {
    return {
      localChecked: this.checked
    };
  },
  computed: {
    isRadioGroup: function isRadioGroup() {
      return true;
    }
  }
});

exports.BFormRadioGroup = BFormRadioGroup;
var _default = BFormRadioGroup;
exports.default = _default;