"use strict";

exports.__esModule = true;
exports.default = exports.warnNoMutationObserverSupport = exports.warnNoPromiseSupport = exports.warnNotClient = exports.warn = void 0;

var _env = require("./env");

/**
 * Log a warning message to the console with BootstrapVue formatting
 * @param {string} message
 */
var warn = function warn(message)
/* istanbul ignore next */
{
  if (!(0, _env.getNoWarn)()) {
    console.warn("[BootstrapVue warn]: ".concat(message));
  }
};
/**
 * Warn when no Promise support is given
 * @param {string} source
 * @returns {boolean} warned
 */


exports.warn = warn;

var warnNotClient = function warnNotClient(source) {
  /* istanbul ignore else */
  if (_env.isBrowser) {
    return false;
  } else {
    warn("".concat(source, ": Can not be called during SSR."));
    return true;
  }
};
/**
 * Warn when no Promise support is given
 * @param {string} source
 * @returns {boolean} warned
 */


exports.warnNotClient = warnNotClient;

var warnNoPromiseSupport = function warnNoPromiseSupport(source) {
  /* istanbul ignore else */
  if (_env.hasPromiseSupport) {
    return false;
  } else {
    warn("".concat(source, ": Requires Promise support."));
    return true;
  }
};
/**
 * Warn when no MutationObserver support is given
 * @param {string} source
 * @returns {boolean} warned
 */


exports.warnNoPromiseSupport = warnNoPromiseSupport;

var warnNoMutationObserverSupport = function warnNoMutationObserverSupport(source) {
  /* istanbul ignore else */
  if (_env.hasMutationObserverSupport) {
    return false;
  } else {
    warn("".concat(source, ": Requires MutationObserver support."));
    return true;
  }
}; // Default export


exports.warnNoMutationObserverSupport = warnNoMutationObserverSupport;
var _default = warn;
exports.default = _default;