"use strict";

exports.__esModule = true;
exports.default = exports.BFormInvalidFeedback = exports.props = void 0;

var _vue = _interopRequireDefault(require("../../utils/vue"));

var _vueFunctionalDataMerge = require("vue-functional-data-merge");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var props = {
  id: {
    type: String,
    default: null
  },
  tag: {
    type: String,
    default: 'div'
  },
  tooltip: {
    type: Boolean,
    default: false
  },
  forceShow: {
    type: Boolean,
    default: false
  },
  state: {
    type: [Boolean, String],
    default: null
  },
  ariaLive: {
    type: String,
    default: null
  },
  role: {
    type: String,
    default: null
  } // @vue/component

};
exports.props = props;

var BFormInvalidFeedback =
/*#__PURE__*/
_vue.default.extend({
  name: 'BFormInvalidFeedback',
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var show = props.forceShow === true || props.state === false || props.state === 'invalid';
    return h(props.tag, (0, _vueFunctionalDataMerge.mergeData)(data, {
      class: {
        'invalid-feedback': !props.tooltip,
        'invalid-tooltip': props.tooltip,
        'd-block': show
      },
      attrs: {
        id: props.id,
        role: props.role,
        'aria-live': props.ariaLive,
        'aria-atomic': props.ariaLive ? 'true' : null
      }
    }), children);
  }
});

exports.BFormInvalidFeedback = BFormInvalidFeedback;
var _default = BFormInvalidFeedback;
exports.default = _default;