"use strict";

exports.__esModule = true;
exports.default = void 0;

var _inspect = require("../../../utils/inspect");

var _sanitizeRow = _interopRequireDefault(require("./sanitize-row"));

var _stringifyObjectValues = _interopRequireDefault(require("./stringify-object-values"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Stringifies the values of a record, ignoring any special top level field keys
// TODO: add option to stringify formatted/scopedSlot items, and only specific fields

/* istanbul ignore next */
var stringifyRecordValues = function stringifyRecordValues(row) {
  return (0, _inspect.isObject)(row) ? (0, _stringifyObjectValues.default)((0, _sanitizeRow.default)(row)) : '';
};

var _default = stringifyRecordValues;
exports.default = _default;