"use strict";

exports.__esModule = true;
exports.default = exports.BPagination = void 0;

var _vue = _interopRequireDefault(require("../../utils/vue"));

var _config = require("../../utils/config");

var _dom = require("../../utils/dom");

var _pagination = _interopRequireDefault(require("../../mixins/pagination"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var NAME = 'BPagination';
var DEFAULT_PER_PAGE = 20;
var DEFAULT_TOTAL_ROWS = 0; // Sanitize the provided per page number (converting to a number)

var sanitizePerPage = function sanitizePerPage(val) {
  var perPage = parseInt(val, 10) || DEFAULT_PER_PAGE;
  return perPage < 1 ? 1 : perPage;
}; // Sanitize the provided total rows number (converting to a number)


var sanitizeTotalRows = function sanitizeTotalRows(val) {
  var totalRows = parseInt(val, 10) || DEFAULT_TOTAL_ROWS;
  return totalRows < 0 ? 0 : totalRows;
};

var props = {
  size: {
    type: String,
    default: function _default() {
      return (0, _config.getComponentConfig)(NAME, 'size');
    }
  },
  perPage: {
    type: [Number, String],
    default: DEFAULT_PER_PAGE
  },
  totalRows: {
    type: [Number, String],
    default: DEFAULT_TOTAL_ROWS
  },
  ariaControls: {
    type: String,
    default: null
  } // The render function is brought in via the pagination mixin
  // @vue/component

};

var BPagination =
/*#__PURE__*/
_vue.default.extend({
  name: NAME,
  mixins: [_pagination.default],
  props: props,
  computed: {
    numberOfPages: function numberOfPages() {
      var result = Math.ceil(sanitizeTotalRows(this.totalRows) / sanitizePerPage(this.perPage));
      return result < 1 ? 1 : result;
    }
  },
  watch: {
    numberOfPages: function numberOfPages(newVal) {
      if (newVal === this.localNumberOfPages) {
        /* istanbul ignore next */
        return;
      }

      this.localNumberOfPages = newVal;
      this.currentPage = 1;
    }
  },
  created: function created() {
    var _this = this;

    // Set the initial page count
    this.localNumberOfPages = this.numberOfPages; // Set the initial page value

    var currentPage = parseInt(this.value, 10) || 0;

    if (currentPage > 0) {
      this.currentPage = currentPage;
    } else {
      this.$nextTick(function () {
        // If this value parses to NaN or a value less than 1
        // Trigger an initial emit of 'null' if no page specified
        _this.currentPage = 0;
      });
    }
  },
  mounted: function mounted() {
    // Set the initial page count
    this.localNumberOfPages = this.numberOfPages;
  },
  methods: {
    // These methods are used by the render function
    onClick: function onClick(num, evt) {
      var _this2 = this;

      // Handle edge cases where number of pages has changed (i.e. if perPage changes)
      // This should normally not happen, but just in case.
      if (num > this.numberOfPages) {
        /* istanbul ignore next */
        num = this.numberOfPages;
      } else if (num < 1) {
        /* istanbul ignore next */
        num = 1;
      } // Update the v-model


      this.currentPage = num; // Emit event triggered by user interaction

      this.$emit('change', this.currentPage);
      this.$nextTick(function () {
        // Keep the current button focused if possible
        var target = evt.target;

        if ((0, _dom.isVisible)(target) && _this2.$el.contains(target) && target.focus) {
          target.focus();
        } else {
          _this2.focusCurrent();
        }
      });
    },
    makePage: function makePage(pageNum) {
      return pageNum;
    },
    linkProps: function linkProps(pageNum) {
      // Always '#' for pagination component
      return {
        href: '#'
      };
    }
  }
});

exports.BPagination = BPagination;
var _default2 = BPagination;
exports.default = _default2;