"use strict";

exports.__esModule = true;
exports.default = void 0;

var _inspect = require("../../../utils/inspect");

var _tr = require("../tr");

var slotName = 'bottom-row';
var _default = {
  methods: {
    renderBottomRow: function renderBottomRow() {
      var h = this.$createElement; // Static bottom row slot (hidden in visibly stacked mode as we can't control the data-label)
      // If in *always* stacked mode, we don't bother rendering the row

      if (!this.hasNormalizedSlot(slotName) || this.stacked === true || this.stacked === '') {
        return h();
      }

      var fields = this.computedFields;
      return h(_tr.BTr, {
        key: 'b-bottom-row',
        staticClass: 'b-table-bottom-row',
        class: [(0, _inspect.isFunction)(this.tbodyTrClass) ? this.tbodyTrClass(null, 'row-bottom') : this.tbodyTrClass]
      }, this.normalizeSlot(slotName, {
        columns: fields.length,
        fields: fields
      }));
    }
  }
};
exports.default = _default;