"use strict";

exports.__esModule = true;
exports.default = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Mixin for providing stacked tables
var _default = {
  props: {
    stacked: {
      type: [Boolean, String],
      default: false
    }
  },
  computed: {
    isStacked: function isStacked() {
      // `true` when always stacked, or breakpoint specified
      return this.stacked === '' ? true : Boolean(this.stacked);
    },
    isStackedAlways: function isStackedAlways() {
      return this.stacked === true || this.stacked === '';
    },
    stackedTableClasses: function stackedTableClasses() {
      return _defineProperty({
        'b-table-stacked': this.isStackedAlways
      }, "b-table-stacked-".concat(this.stacked), !this.isStackedAlways && this.isStacked);
    }
  }
};
exports.default = _default;