"use strict";

exports.__esModule = true;
exports.default = void 0;

var _inspect = require("../../../utils/inspect");

var _tr = require("../tr");

var slotName = 'top-row';
var _default = {
  methods: {
    renderTopRow: function renderTopRow() {
      var h = this.$createElement; // Add static Top Row slot (hidden in visibly stacked mode as we can't control the data-label)
      // If in *always* stacked mode, we don't bother rendering the row

      if (!this.hasNormalizedSlot(slotName) || this.stacked === true || this.stacked === '') {
        return h();
      }

      var fields = this.computedFields;
      return h(_tr.BTr, {
        key: 'b-top-row',
        staticClass: 'b-table-top-row',
        class: [(0, _inspect.isFunction)(this.tbodyTrClass) ? this.tbodyTrClass(null, 'row-top') : this.tbodyTrClass]
      }, [this.normalizeSlot(slotName, {
        columns: fields.length,
        fields: fields
      })]);
    }
  }
};
exports.default = _default;