"use strict";

exports.__esModule = true;
exports.default = exports.TableSimplePlugin = exports.TableLitePlugin = exports.TablePlugin = void 0;

var _table = require("./table");

exports.BTable = _table.BTable;

var _tableLite = require("./table-lite");

exports.BTableLite = _tableLite.BTableLite;

var _tableSimple = require("./table-simple");

exports.BTableSimple = _tableSimple.BTableSimple;

var _tbody = require("./tbody");

exports.BTbody = _tbody.BTbody;

var _thead = require("./thead");

exports.BThead = _thead.BThead;

var _tfoot = require("./tfoot");

exports.BTfoot = _tfoot.BTfoot;

var _tr = require("./tr");

exports.BTr = _tr.BTr;

var _td = require("./td");

exports.BTd = _td.BTd;

var _th = require("./th");

exports.BTh = _th.BTh;

var _plugins = require("../../utils/plugins");

var TableLitePlugin =
/*#__PURE__*/
(0, _plugins.pluginFactory)({
  components: {
    BTableLite: _tableLite.BTableLite
  }
});
exports.TableLitePlugin = TableLitePlugin;
var TableSimplePlugin =
/*#__PURE__*/
(0, _plugins.pluginFactory)({
  components: {
    BTableSimple: _tableSimple.BTableSimple,
    BTbody: _tbody.BTbody,
    BThead: _thead.BThead,
    BTfoot: _tfoot.BTfoot,
    BTr: _tr.BTr,
    BTd: _td.BTd,
    BTh: _th.BTh
  }
});
exports.TableSimplePlugin = TableSimplePlugin;
var TablePlugin =
/*#__PURE__*/
(0, _plugins.pluginFactory)({
  components: {
    BTable: _table.BTable
  },
  plugins: {
    TableLitePlugin: TableLitePlugin,
    TableSimplePlugin: TableSimplePlugin
  }
});
exports.TablePlugin = TablePlugin;
var _default = TablePlugin;
exports.default = _default;