"use strict";

exports.__esModule = true;
exports.default = exports.BTableSimple = void 0;

var _vue = _interopRequireDefault(require("../../utils/vue"));

var _id = _interopRequireDefault(require("../../mixins/id"));

var _normalizeSlot = _interopRequireDefault(require("../../mixins/normalize-slot"));

var _mixinTableRenderer = _interopRequireDefault(require("./helpers/mixin-table-renderer"));

var _mixinStacked = _interopRequireDefault(require("./helpers/mixin-stacked"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Mixins
// Main table renderer mixin
// Feature miins
// b-table-simple component definition
// @vue/component
var BTableSimple =
/*#__PURE__*/
_vue.default.extend({
  name: 'BTableSimple',
  // Order of mixins is important!
  // They are merged from first to last, followed by this component.
  mixins: [// Required mixins
  _id.default, _normalizeSlot.default, _mixinTableRenderer.default, // feature mixin
  // Stacked requires extra handling by users via
  // the table cell `stacked-heading` prop
  _mixinStacked.default],
  computed: {
    isTableSimple: function isTableSimple() {
      return true;
    }
  } // render function provided by table-renderer mixin

});

exports.BTableSimple = BTableSimple;
var _default = BTableSimple;
exports.default = _default;