"use strict";

exports.__esModule = true;
exports.default = void 0;

var _config = require("../utils/config");

// @vue/component
var _default2 = {
  props: {
    size: {
      type: String,
      default: function _default() {
        return (0, _config.getComponentConfig)('formControls', 'size');
      }
    }
  },
  computed: {
    sizeFormClass: function sizeFormClass() {
      return [this.size ? "form-control-".concat(this.size) : null];
    },
    sizeBtnClass: function sizeBtnClass()
    /* istanbul ignore next: don't think this is used */
    {
      return [this.size ? "btn-".concat(this.size) : null];
    }
  }
};
exports.default = _default2;